<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Maatwebsite\Excel\Facades\Excel;
use App\Exports\AuditionListExport;
use App\Registration;
use App\Audition;
use App\Category;
use Session;

class AuditionController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index(Request $request)
    {
        $sideBar = 'AuditionList';

        // get audition ids
        $auditionIdsTmp = Audition::where('is_selfie_submitted', 1);

        // if from date and to date
        if($request->from_date != '' && $request->to_date != ''){
            if(strtotime($request->from_date) == strtotime($request->to_date)){
                $auditionIdsTmp->where(function ($query) use ($request) {
                    $query->whereDate('updated_at', $request->from_date);
                });
            }
            else{
                $auditionIdsTmp->where(function ($query) use ($request) {
                    $query->whereBetween('updated_at', [$request->from_date, $request->to_date]);
                });
            }
        }

        // if category
        if($request->category != '' && $request->category != 'all'){
            $auditionIdsTmp->where(function ($query) use ($request) {
                $query->where('category', $request->category);
            });
        }

        // if result
        if($request->result != '' && $request->result != 'all'){
            $auditionIdsTmp->where(function ($query) use ($request) {
                $query->where('result', $request->result);
            });
        }

        $auditionIds = $auditionIdsTmp->distinct('registration_id')
                            ->pluck('registration_id')
                            ->toArray();

        // get all registration who submitted selfie videos
        $result = Registration::orderBy('updated_at', 'ASC')
                        ->whereIn('id', $auditionIds);

		$lists = $result->paginate(20);

        if ($request->ajax()) {
            return view('admin.audition.ajax-list', ['lists' => $lists])->render();    
        }

        $categories = Category::where('on_payment_page', 1)->orderBy('name', 'ASC')->get();

		return view('admin.audition.list', compact('sideBar', "categories", "lists"));
    }

    public function export(Request $request)
    {
        $from_date = $request->from_date;
        $to_date = $request->to_date;
        $category = $request->category;
        $result = $request->result;

        return Excel::download(new AuditionListExport($from_date, $to_date, $category, $result), 'AuditionList.csv');
    }
}
