<?php

namespace App\Exports;

use App\Registration;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use PhpOffice\PhpSpreadsheet\Shared\Date;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Maatwebsite\Excel\Concerns\WithColumnFormatting;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithColumnWidths;
use Maatwebsite\Excel\Concerns\WithStyles;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;

class RegistrationsExport implements FromCollection, WithHeadings, WithColumnFormatting, WithMapping, ShouldAutoSize, WithColumnWidths, WithStyles
{
    /**
    * @return \Illuminate\Support\Collection
    */
    protected $category;
    protected $from;
    protected $to;

	function __construct($category, $from, $to) {
		$this->category = $category;
		$this->from = $from;
		$this->to = $to;
	}

	public function map($registration): array
    {
        return [
            Date::dateTimeToExcel($registration->updated_at),
            $registration->name,
            $registration->email,
            $registration->phone,
            $registration->category,
            $registration->gender,
            $registration->age_group,
            $registration->getState->name,
            $registration->city,
            $registration->season,
            $registration->platform,
        ];
    }

    public function columnFormats(): array
    {
        return [
            'A' => NumberFormat::FORMAT_DATE_DATETIME,
        ];
    }

    public function columnWidths(): array
    {
        return [
            'A' => 50,
            'B' => 50,            
        ];
    }

    public function styles(Worksheet $sheet)
    {
        $sheet->getStyle('B')->getFont()->setBold(true);
    }

	public function headings(): array
    {
        return [
            'Date',
            'Name',
            'Email',
            'Phone',
            'Category',
            'Gender',
            'Age Group',
            'State',
            'City',
            'Season',
            'Platform',
        ];
    }

    public function registerEvents(): array
    {
        return [
            AfterSheet::class    => function(AfterSheet $event) {
                $event->sheet->getDelegate()->getStyle('A2:W2')->getAlignment()->setVertical(Alignment::VERTICAL_CENTER);
            },
        ];
    }

    public function collection()
    {
        $result = Registration::orderBy('id', 'DESC');

    	if($this->category != '' && $this->category != 'all'){
    		$result->where(function ($query) {
                $query->where('category', $this->category);
            });
    	}

    	if($this->from != '' && $this->to != ''){
            if(strtotime($this->from) == strtotime($this->to)){
                $result->where(function ($query) {
                    $query->whereDate('updated_at', $this->from);
                });
            }
            else{
                $result->where(function ($query) {
                    $query->whereBetween('updated_at', [$this->from, $this->to]);
                });
            }
    	}

    	$registration = $result->get();

        return $registration;
    }
}
