<?php

namespace App\Exports;

use App\Payment;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use PhpOffice\PhpSpreadsheet\Shared\Date;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Maatwebsite\Excel\Concerns\WithColumnFormatting;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithColumnWidths;
use Maatwebsite\Excel\Concerns\WithStyles;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;

class PaymentsExport implements FromCollection, WithHeadings, WithColumnFormatting, WithMapping, ShouldAutoSize, WithColumnWidths, WithStyles
{
    /**
    * @return \Illuminate\Support\Collection
    */
    protected $category;
    protected $from;
    protected $to;

	function __construct($category, $from, $to) {
		$this->category = $category;
		$this->from = $from;
		$this->to = $to;
	}

	public function map($payment): array
    {
        return [
            Date::dateTimeToExcel($payment->payment_at),
            $payment->registration_id,
            $payment->name,
            $payment->email,
            $payment->phone,
            $payment->category,
            $payment->gender,
            $payment->age_group,
            $payment->getState->name,
            $payment->city,
            $payment->season,
            $payment->status,
            $payment->fee,
        ];
    }

    public function columnFormats(): array
    {
        return [
            'A' => NumberFormat::FORMAT_DATE_DATETIME,
        ];
    }

    public function columnWidths(): array
    {
        return [
            'A' => 50,
            'B' => 50,            
        ];
    }

    public function styles(Worksheet $sheet)
    {
        $sheet->getStyle('B')->getFont()->setBold(true);
    }

	public function headings(): array
    {
        return [
            'Date',
            'Registration ID',
            'Name',
            'Email',
            'Phone',
            'Category',
            'Gender',
            'Age Group',
            'State',
            'City',
            'Season',
            'Status',
            'Fee',
        ];
    }

    public function registerEvents(): array
    {
        return [
            AfterSheet::class    => function(AfterSheet $event) {
                $event->sheet->getDelegate()->getStyle('A2:W2')->getAlignment()->setVertical(Alignment::VERTICAL_CENTER);
            },
        ];
    }

    public function collection()
    {
    	$result = Payment::orderBy('payment_at', 'DESC');

    	if($this->category != '' && $this->category != 'all'){
    		$result->where(function ($query) {
                $query->where('category', $this->category);
            });
    	}

    	if($this->from != '' && $this->to != ''){
            if(strtotime($this->from) == strtotime($this->to)){
                $result->where(function ($query) {
                    $query->whereDate('payment_at', $this->from);
                });
            }
            else{
                $result->where(function ($query) {
                    $query->whereBetween('payment_at', [$this->from, $this->to]);
                });
            }
    	}

    	$payment = $result->get();

        return $payment;
    }
}
