<?php

namespace App\Exports;

use App\AuditionAdmin;
use App\Registration;
use App\Audition;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use PhpOffice\PhpSpreadsheet\Shared\Date;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Maatwebsite\Excel\Concerns\WithColumnFormatting;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithColumnWidths;
use Maatwebsite\Excel\Concerns\WithStyles;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;
use Session;

class LastMessageExport implements FromCollection, WithHeadings, WithColumnFormatting, WithMapping, ShouldAutoSize, WithColumnWidths, WithStyles
{
    /**
    * @return \Illuminate\Support\Collection
    */

	public function map($registration): array
    {
        return [
            Date::dateTimeToExcel($registration->updated_at),
            $registration->name,
            $registration->email,
            $registration->phone,
            $registration->category,
            $registration->gender,
            $registration->age_group,
            $registration->getState->name,
            $registration->city,
            $registration->season,
            $registration->platform,
        ];
    }

    public function columnFormats(): array
    {
        return [
            'A' => NumberFormat::FORMAT_DATE_DATETIME,
        ];
    }

    public function columnWidths(): array
    {
        return [
            'A' => 50,
            'B' => 50,            
        ];
    }

    public function styles(Worksheet $sheet)
    {
        $sheet->getStyle('B')->getFont()->setBold(true);
    }

	public function headings(): array
    {
        return [
            'Date',
            'Name',
            'Email',
            'Phone',
            'Category',
            'Gender',
            'Age Group',
            'State',
            'City',
            'Season',
            'Platform',
        ];
    }

    public function registerEvents(): array
    {
        return [
            AfterSheet::class    => function(AfterSheet $event) {
                $event->sheet->getDelegate()->getStyle('A2:W2')->getAlignment()->setVertical(Alignment::VERTICAL_CENTER);
            },
        ];
    }

    public function collection()
    {
        $email = Session::get('audition-admin');

        // get admin
        $admin = AuditionAdmin::where('email', $email)->first();

        // get audition ids
        $auditionIds = Audition::where('category', $admin->getCategory->name)
                            ->where('is_selfie_submitted', 1)
            				->where('result', 4)
            				->distinct('registration_id')
                            ->pluck('registration_id')
                            ->toArray();

        // get all registration who submitted selfie videos
    	$result = Registration::orderBy('updated_at', 'ASC')
                            ->where('category', $admin->getCategory->name)
                            ->whereIn('id', $auditionIds);

        $registration = $result->get();

        return $registration;
    }
}
