<?php

namespace App\Exports;

use App\AuditionAdmin;
use App\Registration;
use App\Audition;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use PhpOffice\PhpSpreadsheet\Shared\Date;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Maatwebsite\Excel\Concerns\WithColumnFormatting;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithColumnWidths;
use Maatwebsite\Excel\Concerns\WithStyles;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;
use Session;

class AuditionListExport implements FromCollection, WithHeadings, WithColumnFormatting, WithMapping, ShouldAutoSize, WithColumnWidths, WithStyles
{
    /**
    * @return \Illuminate\Support\Collection
    */

    protected $from_date;
    protected $to_date;
    protected $category;
    protected $result;

    function __construct($from_date, $to_date, $category, $result) {
        $this->from_date = $from_date;
        $this->to_date = $to_date;
        $this->category = $category;
        $this->result = $result;
    }

	public function map($registration): array
    {
        return [
            Date::dateTimeToExcel($registration->updated_at),
            $registration->name,
            $registration->email,
            $registration->phone,
            $registration->category,
            $registration->gender,
            $registration->age_group,
            $registration->getState->name,
            $registration->city,
            $registration->season,
            $registration->platform,
            ($registration->getSelfie->result == 0 ? 'Not Declared' : ($registration->getSelfie->result == 1 ? 'Selected' : ($registration->getSelfie->result == 2 ? 'Rejected' : ($registration->getSelfie->result == 3 ? 'Re-Invited' : ($registration->getSelfie->result == 4 ? 'Last Message Sent' : ''))))),
        ];
    }

    public function columnFormats(): array
    {
        return [
            'A' => NumberFormat::FORMAT_DATE_DATETIME,
        ];
    }

    public function columnWidths(): array
    {
        return [
            'A' => 50,
            'B' => 50,            
        ];
    }

    public function styles(Worksheet $sheet)
    {
        $sheet->getStyle('B')->getFont()->setBold(true);
    }

	public function headings(): array
    {
        return [
            'Date',
            'Name',
            'Email',
            'Phone',
            'Category',
            'Gender',
            'Age Group',
            'State',
            'City',
            'Season',
            'Platform',
            'Result'
        ];
    }

    public function registerEvents(): array
    {
        return [
            AfterSheet::class    => function(AfterSheet $event) {
                $event->sheet->getDelegate()->getStyle('A2:W2')->getAlignment()->setVertical(Alignment::VERTICAL_CENTER);
            },
        ];
    }

    public function collection()
    {
        // get audition ids
        $auditionIdsTmp = Audition::where('is_selfie_submitted', 1);

        // if from date and to date
        if($this->from_date != '' && $this->to_date != ''){
            if(strtotime($this->from_date) == strtotime($this->to_date)){
                $auditionIdsTmp->where(function ($query) {
                    $query->whereDate('updated_at', $this->from_date);
                });
            }
            else{
                $auditionIdsTmp->where(function ($query) {
                    $query->whereBetween('updated_at', [$this->from_date, $this->to_date]);
                });
            }
        }

        // if category
        if($this->category != '' && $this->category != 'all'){
            $auditionIdsTmp->where(function ($query) {
                $query->where('category', $this->category);
            });
        }

        // if result
        if($this->result != '' && $this->result != 'all'){
            $auditionIdsTmp->where(function ($query) {
                $query->where('result', $this->result);
            });
        }

        $auditionIds = $auditionIdsTmp->distinct('registration_id')
                            ->pluck('registration_id')
                            ->toArray();

        // get all registration who submitted selfie videos
        $result = Registration::orderBy('updated_at', 'ASC')
                        ->whereIn('id', $auditionIds);

        $lists = $result->with('getSelfie')->get();

        return $lists;
    }
}
