<?php
namespace ElementorKayaWidgets\Widgets;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Border;
use Elementor\Utils;
if (!defined('ABSPATH'))
    exit; // Exit if accessed directly

class Elementor_Kaya_Woo_Product_Slider extends Widget_Base {
    public function get_name() {
        return 'elementor-kaya-woo-product-slider';
    }

    public function get_title() {
        return __('Elementor - Kaya - Woo Product Slider', 'ekw');
    }

    public function get_icon() {
        return 'eicon-slider-3d';
    }

    public function get_categories() {
        return array('product-slider');
    }

    protected function _register_controls() {
        $this-> start_controls_section(
            'post_slider',
            [
                'label' => __('Post Slider', 'ekw'),
            ]
        );
        $this->add_control(
            'grid_post_type',
            [
                'label' => __('Post Types', 'ppd'),
                'type' => Controls_Manager::SELECT2,
                'default' => 'post',
                'options' => woo_get_all_post_types(),
            ]
        );
        // Post categories.
        $this->add_control(
            'grid_post_categories',
            [
                'type'      => Controls_Manager::SELECT2,
                'label'     => __( 'Category', 'ekw' ),
                'options'   => woo_get_all_post_type_categories( 'post' ),
                'multiple' => true,
                'condition' => [
                    'grid_post_type' => 'post',
                ],
            ]
        );
        // Product categories.
        $this->add_control(
            'grid_product_categories',
            [
                'label'     => __( 'Category', 'ekw' ),
                'type'      => Controls_Manager::SELECT2,
                'multiple' => true,
                'options'   => woo_get_all_post_type_categories('product'),
                'condition' => [
                    'grid_post_type' => 'product',
                ],
            ]
        );
        $this->add_control(
            'per_line',
            [
                'label' => __('Columns', 'ekw'),
                'type' => Controls_Manager::NUMBER,
                'min' => 2,
                'max' => 8,
                'step' => 1,
                'default' => 4,
            ]
        );
        // Items.
        $this->add_control(
            'slider_items',
            [
                'type'        => Controls_Manager::NUMBER,
                'label'       => __( 'Post Per Page', 'ekw' ),
                'placeholder' => __( 'How many items?', 'ekw' ),
                'default'     => 10,
            ]
        );
        $this->add_control(
            'grid_order_by',
            [
                'label' => __('Order By', 'ekw'),
                'type' => Controls_Manager::SELECT,
                'options' => array(
                    'none' => __('No order', 'ekw'),
                    'ID' => __('Post ID', 'ekw'),
                    'author' => __('Author', 'ekw'),
                    'title' => __('Title', 'ekw'),
                    'date' => __('Published date', 'ekw'),
                    'rand' => __('Random order', 'ekw'),
                    'menu_order' => __('Menu order', 'ekw'),
                ),
                'default' => 'date',
            ]
        );
        $this->add_control(
            'grid_order',
            [
                'label' => __('Order', 'ekw'),
                'type' => Controls_Manager::SELECT,
                'options' => array(
                    'ASC' => __('Ascending', 'ekw'),
                    'DESC' => __('Descending', 'ekw'),
                ),
                'default' => 'DESC',
            ]
        );
        $this->end_controls_section();
        $this-> start_controls_section(
            'woo_image_section',
            [
                'label' => __('Image Settings','ekw'),
                'tab' => Controls_Manager::TAB_SETTINGS,
            ]
        );
        // Hide image.
        $this->add_control(
            'kaya_image_hide',
            [
                'label'   => '<i class="fa fa-minus-circle"></i> ' . __( 'Hide', 'ekw' ),
                'type'    => Controls_Manager::SWITCHER,
                'default' => '',
            ]
        );
        /*$this->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name' => 'image_size', // Actually its `image_size`.
                'label' => __( 'Image Size', 'ekw' ),
                'default' => 'medium',
                'condition' => [
                    'kaya_image_hide' => '',
                ],
            ]
        );*/
        $this-> end_controls_section();
        $this-> start_controls_section(
            'woo_title_section',
            [
                'label' => __('Title Settings', 'ekw'),
                'tab'   => Controls_Manager::TAB_SETTINGS,
            ]
        );
        // Hide title.
        $this->add_control(
            'kaya_title_hide',
            [
                'label'   => '<i class="fa fa-minus-circle"></i> ' . __( 'Title Hide', 'ekw' ),
                'type'    => Controls_Manager::SWITCHER,
                'default' => '',
            ]
        );
        $this->add_control(
            'title_font_size',
            [
                'label' => __('Font Size', 'ekw'),
                'type' => Controls_Manager::SLIDER,
                'default' => [
                    'size' => 24,
                ],
                'range' => [
                    'px' => [
                        'max' => 80,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .post-woo-slider-wrapper .title-meta-data-wrapper h3' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'kaya_title_hide' => '',
                ],
            ]
        );
        $this->add_control(
            'title_font_weight',
            [
                'label' => __( 'Font Weight', 'ekw' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'normal' => __( 'Normal', 'ekw' ),
                    'bold' => __( 'Bold', 'ekw' ),
                ],
                'default' => 'normal',
                'selectors' => [
                    '{{WRAPPER}} .post-woo-slider-wrapper .title-meta-data-wrapper h3' => 'font-weight:{{VALUE}};',
                ],
                'condition' => [
                    'kaya_title_hide' => '',
                ],
            ]
        );
        $this->add_control(
            'title_font_style',
            [
                'label' => __( 'Title Font Style', 'ekw' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'normal' => __( 'Normal', 'ekw' ),
                    'italic' => __( 'Italic', 'ekw' ),
                ],
                'default' => 'normal',
                'selectors' => [
                    '{{WRAPPER}} .post-woo-slider-wrapper .title-meta-data-wrapper h3' => 'font-style: {{VALUE}}!important;',
                ],
                'condition' => [
                    'kaya_title_hide' => '',
                ],
            ]
        );
        $this->add_responsive_control(
            'grid_title_alignment',
            [
                'label'          => __( 'Title alignment', 'ekw' ),
                'type'           => Controls_Manager::CHOOSE,
                'options'        => [
                    'left'    => [
                        'title' => __( 'Left', 'ekw' ),
                        'icon'  => 'fa fa-align-left',
                    ],
                    'center'  => [
                        'title' => __( 'Center', 'ekw' ),
                        'icon'  => 'fa fa-align-center',
                    ],
                    'right'   => [
                        'title' => __( 'Right', 'ekw' ),
                        'icon'  => 'fa fa-align-right',
                    ],
                ],
                'default'        => 'center',
                'selectors'      => [
                    '{{WRAPPER}} .post-woo-slider-wrapper .title-meta-data-wrapper h3' => 'text-align: {{VALUE}};',
                ],
                'condition' => [
                    'kaya_title_hide' => '',
                ],
            ]
        );
        $this-> end_controls_section();
        $this-> start_controls_section(
            'woo_meta_section',
            [
                'label' => __('Meta Data Settings', 'ekw'),
                'tab'   => Controls_Manager::TAB_SETTINGS,
            ]
        );
        // Hide content.
        $this->add_control(
            'kaya_meta_hide',
            [
                'label'   => '<i class="fa fa-minus-circle"></i> ' . __( 'Hide', 'ekw' ),
                'type'    => Controls_Manager::SWITCHER,
                'default' => '',
            ]
        );
        // Meta.
        $this->add_control(
            'woo_meta_display',
            [
                'label'       => '<i class="fa fa-info-circle"></i> ' . __( 'Display', 'ekw' ),
                'label_block' => true,
                'type'        => Controls_Manager::SELECT2,
                'default'     => [ 'author', 'date' ],
                'multiple'    => true,
                'options'     => [
                    'author'   => __( 'Author', 'ekw' ),
                    'date'     => __( 'Date', 'ekw' ),
                    'category' => __( 'Category', 'ekw' ),
                    'tags'     => __( 'Tags', 'ekw' ),
                    'comments' => __( 'Comments', 'ekw' ),
                ],
                'condition' => [
                    'kaya_meta_hide' => '',
                ],
            ]
        );
        // No. of Categories.
        $this->add_control(
            'woo_meta_categories_max',
            [
                'type'        => Controls_Manager::NUMBER,
                'label'       => __( 'No. of Categories', 'ekw' ),
                'placeholder' => __( 'How many categories to display?', 'ekw' ),
                'default'     => __( '1', 'ekw' ),
                'condition'   => [
                    'woo_meta_display' => 'category',
                ],
            ]
        );
        // No. of Tags.
        $this->add_control(
            'woo_meta_tags_max',
            [
                'type'        => Controls_Manager::NUMBER,
                'label'       => __( 'No. of Tags', 'ekw' ),
                'placeholder' => __( 'How many tags to display?', 'ekw' ),
                'condition'   => [
                    'woo_meta_display' => 'tags',
                ],
            ]
        );
        // Remove meta icons.
        $this->add_control(
            'woo_meta_remove_icons',
            [
                'label'   => '<i class="fa fa-minus-circle"></i> ' . __( 'Remove icons', 'ekw' ),
                'type'    => Controls_Manager::SWITCHER,
                'default' => '',
                'condition' => [
                    'kaya_meta_hide' => '',
                ],
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'section_grid_content',
            [
                'label' => __( 'Content', 'ekw' ),
                'tab'   => Controls_Manager::TAB_SETTINGS,
            ]
        );
        // Hide content.
        $this->add_control(
            'kaya_content_hide',
            [
                'label'   => '<i class="fa fa-minus-circle"></i> ' . __( 'Hide', 'ekw' ),
                'type'    => \Elementor\Controls_Manager::SWITCHER,
                'default' => '',
            ]
        );
        // Show full content.
        $this->add_control(
            'woo_content_full_post',
            [
                'label'   => __( 'Show full content', 'ekw' ),
                'type'    => Controls_Manager::SWITCHER,
                'default' => '',
                'condition' => [
                    'kaya_content_hide' => '',
                ],
            ]
        );
        // Length.
        $this->add_control(
            'woo_content_length',
            [
                'type'        => Controls_Manager::NUMBER,
                'label'       => '<i class="fa fa-arrows-h"></i> ' . __( 'Length (words)', 'ekw' ),
                'placeholder' => __( 'Length of content (words)', 'ekw' ),
                'default'     => 30,
                'condition'   => [
                        'woo_content_full_post!' => 'yes'
                ]
            ]
        );
        // Read more button hide.
        $this->add_control(
            'grid_content_default_btn',
            [
                'label'     => '<i class="fa fa-check-square"></i> ' . __( 'Read More Button', 'ekw' ),
                'type'      => Controls_Manager::SWITCHER,
                'default'   => '',
                'condition' => [
                    'woo_content_full_post' => 'yes',
                ],
            ]
        );
        // Default button text.
        $this->add_control(
            'grid_content_default_btn_text',
            [
                'type'        => Controls_Manager::TEXT,
                'label'       => __( 'Button text', 'ekw' ),
                'placeholder' => __( 'Read more', 'ekw' ),
                'default'     => __( 'Read more', 'ekw' ),
                'condition'   => [
                    'grid_content_default_btn'    => 'no',
                    'section_grid.grid_post_type!' => 'product',
                ],
            ]
        );
        $this->add_control(
            'content_font_size',
            [
                'label' => __('Font Size', 'ekw'),
                'type' => Controls_Manager::SLIDER,
                'default' => [
                    'size' => 18,
                ],
                'range' => [
                    'px' => [
                        'max' => 80,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .post-woo-slider-wrapper .woo-entry-content, .woo-data-content p' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'kaya_content_hide' => '',
                ],
            ]
        );
        $this->add_control(
            'content_font_weight',
            [
                'label' => __( 'Font Weight', 'ekw' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'normal' => __( 'Normal', 'ekw' ),
                    'bold' => __( 'Bold', 'ekw' ),
                ],
                'default' => 'normal',
                'selectors' => [
                    '{{WRAPPER}} .post-woo-slider-wrapper .woo-entry-content, .woo-data-content p' => 'font-weight:{{VALUE}};',
                ],
                'condition' => [
                    'kaya_content_hide' => '',
                ],
            ]
        );
        $this->add_control(
            'content_font_style',
            [
                'label' => __( 'Title Font Style', 'ekw' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'normal' => __( 'Normal', 'ekw' ),
                    'italic' => __( 'Italic', 'ekw' ),
                ],
                'default' => 'normal',
                'selectors' => [
                    '{{WRAPPER}} .post-woo-slider-wrapper .woo-entry-content, .woo-data-content p' => 'font-style: {{VALUE}}!important;',
                ],
                'condition' => [
                    'kaya_content_hide' => '',
                ],
            ]
        );
        // Content alignment.
        $this->add_responsive_control(
            'woo_content_alignment',
            [
                'label'          => '<i class="fa fa-align-right"></i> ' . __( 'Alignment', 'ekw' ),
                'type'           => \Elementor\Controls_Manager::CHOOSE,
                'options'        => [
                    'left'   => [
                        'title' => __( 'Left', 'ekw' ),
                        'icon'  => 'fa fa-align-left',
                    ],
                    'center' => [
                        'title' => __( 'Center', 'ekw' ),
                        'icon'  => 'fa fa-align-center',
                    ],
                    'right'  => [
                        'title' => __( 'Right', 'ekw' ),
                        'icon'  => 'fa fa-align-right',
                    ],
                ],
                'default'        => 'center',
                'selectors'      => [
                    '{{WRAPPER}} .woo-entry-content, .woo-data-content p' => 'text-align: {{VALUE}};',
                ],
                'condition' => [
                    'kaya_content_hide' => '',
                ],
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'price_content_section',
            [
                'label' => __('Price Settings', 'ekw'),
                'tab'   => Controls_Manager::TAB_SETTINGS,
            ]
        );
        $this->add_control(
            'woo_content_price',
            [
                'label'     => '<i class="fa fa-usd"></i> ' . __( 'Price', 'ekw' ),
                'type'      => Controls_Manager::SWITCHER,
                'default'   => 'yes',
                'condition' => [
                    'section_grid.grid_post_type' => 'product',
                ],
            ]
        );
        $this->add_control(
            'price_font_size',
            [
                'label' => __('Font Size', 'ekw'),
                'type' => Controls_Manager::SLIDER,
                'default' => [
                    'size' => 18,
                ],
                'range' => [
                    'px' => [
                        'max' => 80,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .post-woo-slider-wrapper .woo-post-price span' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'woo_content_price' => 'yes',
                ],
            ]
        );
        $this->add_control(
            'price_font_weight',
            [
                'label' => __( 'Font Weight', 'ekw' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'normal' => __( 'Normal', 'ekw' ),
                    'bold' => __( 'Bold', 'ekw' ),
                ],
                'default' => 'normal',
                'selectors' => [
                    '{{WRAPPER}} .post-woo-slider-wrapper .woo-post-price span' => 'font-weight:{{VALUE}};',
                ],
                'condition' => [
                    'woo_content_price' => 'yes',
                ],
            ]
        );
        $this->add_control(
            'price_font_style',
            [
                'label' => __( 'Title Font Style', 'ekw' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'normal' => __( 'Normal', 'ekw' ),
                    'italic' => __( 'Italic', 'ekw' ),
                ],
                'default' => 'normal',
                'selectors' => [
                    '{{WRAPPER}} .post-woo-slider-wrapper .woo-post-price span' => 'font-style: {{VALUE}}!important;',
                ],
                'condition' => [
                    'woo_content_price' => 'yes',
                ],
            ]
        );
        $this->add_responsive_control(
            'price_alignment',
            [
                'label'          => '<i class="fa fa-align-right"></i> ' . __( 'Alignment', 'ekw' ),
                'type'           => \Elementor\Controls_Manager::CHOOSE,
                'options'        => [
                    'left'   => [
                        'title' => __( 'Left', 'ekw' ),
                        'icon'  => 'fa fa-align-left',
                    ],
                    'center' => [
                        'title' => __( 'Center', 'ekw' ),
                        'icon'  => 'fa fa-align-center',
                    ],
                    'right'  => [
                        'title' => __( 'Right', 'ekw' ),
                        'icon'  => 'fa fa-align-right',
                    ],
                ],
                'default'        => 'center',
                'selectors'      => [
                    '{{WRAPPER}} .post-woo-slider-wrapper .woo-post-price' => 'text-align: {{VALUE}};',
                ],
                'condition' => [
                    'woo_content_price' => 'yes',
                ],
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'cart_button_section',
            [
                'label' => __('Button Settings', 'ekw'),
                'tab'   => Controls_Manager::TAB_SETTINGS,
            ]
        );
        // Add to cart button hide.
        $this->add_control(
            'woo_cart_button',
            [
                'label'     => '<i class="fa fa-check-square"></i> ' . __( 'Button', 'ekw' ),
                'type'      => Controls_Manager::SWITCHER,
                'default'   => 'yes',
            ]
        );
        $this->add_responsive_control(
            'button_alignment',
            [
                'label'          => '<i class="fa fa-align-right"></i> ' . __( 'Alignment', 'ekw' ),
                'type'           => Controls_Manager::CHOOSE,
                'options'        => [
                    'left'   => [
                        'title' => __( 'Left', 'ekw' ),
                        'icon'  => 'fa fa-align-left',
                    ],
                    'center' => [
                        'title' => __( 'Center', 'ekw' ),
                        'icon'  => 'fa fa-align-center',
                    ],
                    'right'  => [
                        'title' => __( 'Right', 'ekw' ),
                        'icon'  => 'fa fa-align-right',
                    ],
                ],
                'default'        => 'center',
                'selectors'      => [
                    '{{WRAPPER}} .post-woo-slider-wrapper .woo-footer-data' => 'text-align: {{VALUE}};',
                ],
                'condition' => [
                    'woo_cart_button' => 'yes',
                ],
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'woo_styles_section',
            [
                'label' => __('Color Styles Section', 'ekw'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'title_color',
            [
                'label' => __('Title Color', 'ekw'),
                'type' => Controls_Manager::COLOR,
                'default' => '#000',
                'selectors' => [
                    '{{WRAPPER}} .post-woo-slider-wrapper .title-meta-data-wrapper h3 a' => 'color: {{VALUE}};',  
                ],
                'condition' => [
                    'kaya_title_hide' => '',
                ],
            ]
        );
        $this->add_control(
            'meta_data_color',
            [
                'label' => __('Meta Fields Color', 'ekw'),
                'type' => Controls_Manager::COLOR,
                'default' => '#000',
                'selectors' => [
                    '{{WRAPPER}} .post-woo-slider-wrapper .woo-entry-meta, .woo-meta-data' => 'color: {{VALUE}};',  
                ],
                'condition' => [
                    'kaya_meta_hide' => '',
                ],
            ]
        );
        $this->add_control(
            'content_color',
            [
                'label' => __('Content Color', 'ekw'),
                'type' => Controls_Manager::COLOR,
                'default' => '#000',
                'selectors' => [
                    '{{WRAPPER}} .post-woo-slider-wrapper .woo-entry-content, .woo-data-content p' => 'color: {{VALUE}};',  
                ],
                'condition' => [
                    'kaya_content_hide' => '',
                ],
            ]
        );
        $this->add_control(
            'price_color',
            [
                'label' => __('Price Color', 'ekw'),
                'type' => Controls_Manager::COLOR,
                'default' => '#868686',
                'selectors' => [
                    '{{WRAPPER}} .post-woo-slider-wrapper .woo-post-price span' => 'color: {{VALUE}};',  
                ],
                'condition' => [
                    'woo_content_price' => 'yes',
                ],
            ]
        );
        $this->add_control(
            'button_BG_color',
            [
                'label' => __('Button BG Color', 'ekw'),
                'type' => Controls_Manager::COLOR,
                'default' => '#f85204',
                'selectors' => [
                    '{{WRAPPER}} .post-woo-slider-wrapper .woo-footer-data a' => 'background: {{VALUE}};',  
                ],
                'condition' => [
                    'woo_cart_button' => 'yes',
                ],
            ]
        );
        $this->add_control(
            'button_color',
            [
                'label' => __('Button Color', 'ekw'),
                'type' => Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .post-woo-slider-wrapper .woo-footer-data a' => 'color: {{VALUE}};',  
                ],
                'condition' => [
                    'woo_cart_button' => 'yes',
                ],
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'woo_hover_styles_section',
            [
                'label' => __('Hover Color Styles Section', 'ekw'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'title_hover_color',
            [
                'label' => __('Title Hover Color', 'ekw'),
                'type' => Controls_Manager::COLOR,
                'default' => '#727272',
                'selectors' => [
                    '{{WRAPPER}} .post-woo-slider-wrapper .title-meta-data-wrapper h3 a:hover' => 'color: {{VALUE}};',  
                ],
                'condition' => [
                    'kaya_title_hide' => '',
                ],
            ]
        );
        $this->add_control(
            'button_BG_hover_color',
            [
                'label' => __('Button BG Hover Color', 'ekw'),
                'type' => Controls_Manager::COLOR,
                'default' => '#03c1c4',
                'selectors' => [
                    '{{WRAPPER}} .post-woo-slider-wrapper .woo-footer-data a:hover' => 'background: {{VALUE}};',  
                ],
                'condition' => [
                    'woo_cart_button' => 'yes',
                ],
            ]
        );
        $this->add_control(
            'button_hover_color',
            [
                'label' => __('Button Hover Color', 'ekw'),
                'type' => Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .post-woo-slider-wrapper .woo-footer-data a:hover' => 'color: {{VALUE}};',  
                ],
                'condition' => [
                    'woo_cart_button' => 'yes',
                ],  
            ]
        );
        $this->end_controls_section();
    }

    protected function render() {
        // Get settings.
        $settings = $this->get_settings();
        $product  = wc_get_product( get_the_ID() );
        ?>
        <style>
        div#reviews{
            display: none;
        }
        </style>
        <script>
            (function($) {
              "use strict";
                $(function() {
                    jQuery(document).ready(function($){
                        $('.woo-slider-view').each(function(){
                          var $column = $(this).data('columns');
                          var $responsive_columns2 = ( ($column == '3' ) || ( $column == '4'  ) || ( $column == '5' )  || ( $column == '6'  ) ) ? '2' : $column;
                          var $responsive_columns3 = ( ($column == '3' ) || ( $column == '4'  ) || ( $column == '5' )  || ( $column == '6'  ) ) ? '3' : $column;
                            $(this).owlCarousel({
                                autoWidth:false,
                                loop:true,
                                margin:10,
                                nav:false,
                                items:$column,
                                responsive:{
                                    0:{
                                        items:1
                                    },
                                    500:{
                                        items:$responsive_columns2,
                                    },
                                    768:{
                                      items:$responsive_columns3,
                                       loop:false,
                                    },
                                    1000:{
                                    }
                                }
                            })
                        });
                    });
                });
            }(jQuery));
        </script>
       <?php
        // Output.
        echo '<div class="post-woo-slider-wrapper woo-slider-view owl-carousel" data-columns="'.$settings['per_line'].'">';
            // Arguments for query.
            $args = array();
            // Display only published posts.
            $args['post_status'] = 'publish';
            // Ignore sticky posts.
            $args['ignore_sticky_posts'] = 1;
            // Check if post type exists.
            if ( ! empty( $settings['grid_post_type'] ) && post_type_exists( $settings['grid_post_type'] ) ) {
                $args['post_type'] = $settings['grid_post_type'];
            }
            // Display posts in category.
            if ( ! empty( $settings['grid_post_categories'] ) && $settings['grid_post_type'] == 'post' ) {
                $args['category_name'] = $settings['grid_post_categories'];
            }
            // Display products in category.
            if ( ! empty( $settings['grid_product_categories'] ) && $settings['grid_post_type'] == 'product' ) {
                $args['tax_query'] = array(
                    'relation' => 'AND',
                    array(
                        'taxonomy' => 'product_cat',
                        'field'    => 'slug',
                        'terms'    => $settings['grid_product_categories'],
                    ),
                );
            }
            // Order by.
            if ( ! empty( $settings['grid_order_by'] ) ) {
                $args['orderby'] = $settings['grid_order_by'];
            }
            // Order.
            if ( ! empty( $settings['grid_order'] ) ) {
                $args['order'] = $settings['grid_order'];
            }
            // Pagination.
            if ( ! empty( $settings['grid_pagination'] ) ) {
                $paged         = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;
                $args['paged'] = $paged;
            }
            // Items to display.
            if ( ! empty( $settings['slider_items'] ) && intval( $settings['slider_items'] ) == $settings['slider_items'] ) {
               $args['posts_per_page'] = $settings['slider_items'];
            }
            // Query.
            $query = new \WP_Query( $args );
            $loop_query = new \WP_Query( array(  
                //'post_type' => $settings['grid_post_type'],
                'posts_per_page' =>  -1,
                'tax_query' => $the_taxes,
            ));
            // Query results.
            if ( $query->have_posts() ) {
                while ( $query->have_posts() ) {
                    $query->the_post();
                    // Check if post type has featured image.
                    $template_file = locate_template( 'elementor-post-widget-styles.php' );
                    if(isset($_SESSION['shortlist'])) {
                        if ( in_array(get_the_ID(), $_SESSION['shortlist']) ) {
                            $selected = 'item_selected';
                        }else{
                            $selected = '';
                        }
                    }else{
                        $selected = '';
                    }
                    echo '<div class="kaya-item '.$selected.'" id="'.get_the_ID().'">';
                        if( $template_file ){
                           include $template_file;
                        }else{
                            include ELEMENTOR_KAYA_PLUGIN_PATH.'templates/elementor-post-widget-styles.php';
                        }
                    echo '</div>'; 
                }
            } // endwhile;
            // endif;
        echo '</div>';
    }
    protected function content_template() {
    }
}