<?php
namespace ElementorKayaWidgets\Widgets;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
if (!defined('ABSPATH'))
    exit; // Exit if accessed directly

class Kaya_User_Grid_Slider_Widget extends Widget_Base {
    public function get_name() {
        return 'kaya-user-grid-slider-view';
    }
    public function get_title() {
        return __('Kaya - User Profile Slider', 'pud');
    }
    public function get_icon() {
        return 'eicon-posts-grid';
    }
    protected function _register_controls() {
        $this->start_controls_section(
            'section_query',
            [
                'label' => __('Post Query', 'pud'),
            ]
        );

        $this->add_control(
            'user_role_type',
            [
                'label' => __('Choose Rles <br> you want to display', 'pud'),
                'type' => Controls_Manager::SELECT2,
                'default' => 'subscriber',
                'options' => kaya_get_user_style_roles(),
                'multiple' => true
            ]
        );

        $this->add_control(
            'orderby',
            [
                'label' => __('Order By', 'pud'),
                'type' => Controls_Manager::SELECT,
                'options' => array(
                    'none' => __('Random', 'pud'),
                    'ID' => __('ID', 'pud'),
                    'name' => __('Name', 'pud'),
                ),
                'default' => 'date',
            ]
        );

        $this->add_control(
            'order',
            [
                'label' => __('Order', 'pud'),
                'type' => Controls_Manager::SELECT,
                'options' => array(
                    'ASC' => __('Ascending', 'pud'),
                    'DESC' => __('Descending', 'pud'),
                ),
                'default' => 'DESC',
            ]
        );
        $this->end_controls_section();
        // Column  settings
        $this->start_controls_section(
            'section_responsive',
            [
                'label' => __('Column Settings', 'pud'),
            ]
        );
/*
        $this->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name' => 'image_size', // Actually its `image_size`.
                'label' => __( 'Profile Image Size', 'pud' ),
                'default' => 'thumbnail',
            ]
        );
  */     
        $this->add_control(
            'per_line',
            [
                'label' => __('Columns', 'pud'),
                'type' => Controls_Manager::NUMBER,
                'min' => 3,
                'max' => 8,
                'step' => 1,
                'default' => 4,
            ]
        );

    }

    protected function render() {
        $settings = $this->get_settings();
        $taxonomy_cats = !empty($settings['tax_query']) ? $settings['tax_query'] : '';
      //  $custom_img_sizes = $settings['image_size_size']; 
      //  $image_sizes = ( $settings['image_size_size'] == 'custom' ) ? array_values($settings['image_size_custom_dimension']) : $settings['image_size_size'];
       // $gutter = ($settings['gutter'] == 'yes') ? 'gutter' : '';
      //  $template_file = locate_template( 'elementor-user-widget-styles.php' ); ?>
        <script type="text/javascript">
            (function($) {
              "use strict";
              $(function() {
                $('.user-grid-slider-view').each(function(){
                  var $column = $(this).data('columns');
                  var $responsive_columns2 = ( ($column == '3' ) || ( $column == '4'  ) || ( $column == '5' )  || ( $column == '6'  ) ) ? '2' : $column;
                  var $responsive_columns3 = ( ($column == '3' ) || ( $column == '4'  ) || ( $column == '5' )  || ( $column == '6'  ) ) ? '3' : $column;
                  $(this).owlCarousel({
                    loop:true,
                    resize:true,
                    autoWidth:false,
                    margin:10,
                    nav:false,
                    items:$column,
                    responsive:{
                        0:{
                            items:1
                        },
                        500:{
                            items:$responsive_columns2,
                             
                        },
                        768:{
                          items:$responsive_columns3,
                           loop:false,
                        },
                        1000:{
                        }
                        }
                    })
                  });
                jQuery(window).load( function() {
                  window.dispatchEvent(new Event('resize'));
                });
                })
            }(jQuery));
        </script>
        <div class="user-data-wrapper user-grid-slider-view owl-carousel" data-columns="<?php echo $settings['per_line'] ?>">
                <?php 
                    $users = new \WP_User_Query(array(
                        'role__in' => $settings['user_role_type'],
                        'orderby' => $settings['orderby'], 
                        'order' => $settings['order'],
                        'meta_key'=>'last_name',
                        'fields'=>'all_with_meta'
                    ));
                    if ( ! empty( $users->results ) ) {
                        foreach ( $users->results as $user ) {
                            $user_meta_info = get_user_meta($user->ID );
                            $user_id = $user->ID;
                            $user_name =  $user->display_name;
                           echo '<div>';
                             
                                   include ELEMENTOR_KAYA_PLUGIN_PATH .'/templates/elementor-user-widget-styles.php';

                              
                            echo '</div>';
                        }
                    }
                ?>
        </div>
       <?php
    }
    protected function content_template() {
    }
}