<?php
namespace ElementorKayaWidgets\Widgets;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Utils;
if (!defined('ABSPATH'))
    exit; // Exit if accessed directly

class Elementor_Kaya_Pricing_Table extends Widget_Base {
    public function get_name() {
        return 'elementor-kaya-pricing-table';
    }

    public function get_title() {
        return __('Elementor - Kaya Pricing Table', 'ekw');
    }

    public function get_icon() {
        return 'eicon-posts-carousel';
    }

    public function get_categories() {
        return array('ekw');
    }

    protected function _register_controls() {
        $this->start_controls_section(
            'section_pricing_image_controls',
            [
                'label' => __('Pricing Table Header', 'ekw' ),
            ]
        );
        /*$this->add_control(
            'pricing_image_upload',
            [
                'label' => __('Choose Image', 'ekw' ),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name' => 'pricing_image_upload', // Actually its `image_size`.
                'label' => __( 'Image Size', 'ekw' ),
                'default' => 'medium',
            ]
        );*/
        $this->add_control(
            'pricing_title_text',
            [
                'label' => __('Title Text', 'ekw' ),
                'type' => Controls_Manager::TEXT,
                'default' => __('Classic', 'ekw' ),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'pricing_desc_text',
            [
                'label' => __('Description Text', 'ekw' ),
                'type' => Controls_Manager::TEXT,
                'default' => __('This is the package for expanding your interior decoration', 'ekw' ),
                'label_block' => true,
            ]
        );
        $this->add_responsive_control(
           'top_content_alignment',
            [
                'label' => __( 'Top Content Alignment', 'ekw' ),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => __( 'Left', 'ekw' ),
                        'icon' => 'fa fa-align-left',
                    ],
                   'center' => [
                        'title' => __( 'Center', 'ekw' ),
                        'icon' => 'fa fa-align-center',
                    ],
                    'right' => [
                        'title' => __( 'Right', 'ekw' ),
                        'icon' => 'fa fa-align-right',
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .price-header' => 'text-align: {{VALUE}};',
                ],
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'section_pricing_title',
            [
                'label' => __('Pricing Title', 'ekw' ),
                'tab' => Controls_Manager::TAB_SETTINGS,
            ]
        );
        $this->add_control(
            'pricing_title_spacing',
            [
                'label' => __('Title Spacing', 'ekw' ),
                'type' => Controls_Manager::SLIDER,
                'default' => [
                    'size' => 10,
                ],
                'range' => [
                    'px' => [
                        'max' => 80,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .price-header h2' => 'padding-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'pricing_title_font_size',
           [
                'label' => __( 'Title Font Size', 'ekw' ),
                'type' => Controls_Manager::SLIDER,
                'default' => [
                    'size' => 40,
                ],
                'range' => [
                    'px' => [
                        'max' => 80,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .price-header h2' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'pricing_title_font_weight',
            [
                'label' => __( 'Title Font Weight', 'ekw' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'normal' => __( 'Normal', 'ekw' ),
                    'bold' => __( 'Bold', 'ekw' ),
                ],
                'default' => 'bold',
                'selectors' => [
                    '{{WRAPPER}} .price-header h2' => 'font-weight:{{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'pricing_title_font_style',
            [
                'label' => __( 'Title Font Style', 'ekw' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'normal' => __( 'Normal', 'ekw' ),
                    'italic' => __( 'Italic', 'ekw' ),
                ],
                'default' => 'normal',
                'selectors' => [
                    '{{WRAPPER}} .price-header h2' => 'font-style: {{VALUE}}!important;',
                ],
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'section_pricing_description',
            [
                'label' => __('Pricing Description', 'ekw' ),
                'tab' => Controls_Manager::TAB_SETTINGS,
            ]
        );
        $this-> add_control(
            'pricing_desc_font_size',
            [
                'label' => __('Description Font Size', 'ekw' ),
                'type' => Controls_Manager::SLIDER,
                'default' => [
                    'size' => 14,
                ],
                'range' => [
                    'px' => [
                        'max' => 80,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .price-header p' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'pricing_desc_font_weight',
            [
                'label' => __( 'Description Font Weight', 'ekw' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'normal' => __( 'Normal', 'ekw' ),
                    'bold' => __( 'Bold', 'ekw' ),
                ],
                'default' => 'normal',
                'selectors' => [
                    '{{WRAPPER}} .price-header p' => 'font-weight:{{VALUE}}!important   ;',
                ],
            ]
        );
        $this->add_control(
            'pricing_desc_font_style',
            [
                'label' => __( 'Description Font Style', 'ekw' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'normal' => __( 'Normal', 'ekw' ),
                    'italic' => __( 'Italic', 'ekw' ),
                ],
                'default' => 'normal',
                'selectors' => [
                    '{{WRAPPER}} .price-header p' => 'font-style: {{VALUE}}!important;',
                ],
            ]
        );
        $this-> end_controls_section();
        $this->start_controls_section(
            'section_pricing_content',
            [
                'label' => __('Pricing Content', 'ekw' ),
                'tab' => Controls_Manager::TAB_SETTINGS,
            ]
        );
       $this-> add_control(
            'pricing_content_desc',
            [
                'label' => __('Pricing Content', 'ekw' ),
                'type' => Controls_Manager::TEXTAREA,
                'default' => __('<ul>
                        <li><i class="fa fa-check"></i> Interior Decoration</li>
                        <li><i class="fa fa-check"></i> Lighting Effects</li>
                        <li><i class="fa fa-check"></i> Roof Sealing</li>
                        <li><i class="fa fa-times"></i> Gardening</li>
                        <li><i class="fa fa-times"></i> Wood Work</li>
                        <li><i class="fa fa-times"></i> Plumber Technicians</li>
                        <li><i class="fa fa-check"></i> Electrical Work</li>
                        <li><i class="fa fa-check"></i> Welding Material</li>
                    </ul>', 'ekw' ),
                'label_block' => true,
            ]
        );

       $this-> add_control(
            'pricing_content_font_size',
            [
                'label' => __('Content Font Size', 'ekw' ),
                'type' => Controls_Manager::SLIDER,
                'default' => [
                    'size' => 14,
                ],
                'range' => [
                   'px' => [
                        'max' => 80,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} #kaya-price-table, .price-body li' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
           'pricing_content_font_weight',
            [
                'label' => __( 'Content Font Weight', 'ekw' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                   'normal' => __( 'Normal', 'ekw' ),
                    'bold' => __( 'Bold', 'ekw' ),
                ],
                'default' => 'normal',
                'selectors' => [
                    '{{WRAPPER}} #kaya-price-table, .price-body li' => 'font-weight:{{VALUE}}!important;',
                ],
            ]
        );
        $this->add_control(
            'pricing_content_font_style',
            [
                'label' => __( 'Content Font Style', 'ekw' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'normal' => __( 'Normal', 'ekw' ),
                    'italic' => __( 'Italic', 'ekw' ),
                ],
                'default' => 'normal',
                'selectors' => [
                    '{{WRAPPER}} #kaya-price-table, .price-body li' => 'font-style: {{VALUE}}!important;',
                ],
            ]
        );
        $this->end_controls_section();
        $this-> start_controls_section(
            'pricing_text',
            [
                'label' => __('Pricing Text', 'ekw'),
                'tab' => Controls_Manager::TAB_SETTINGS,
            ]
        );
        $this-> add_control(
            'pricing_price',
            [
                'label' => __('Price','ekw' ),
                'type' => Controls_Manager::TEXT,
                'default' => __('$199.00  <strong>/ per Month</strong>', 'ekw'),
                'label_block' => true,
            ]
        );
        $this-> add_control(
            'pricing_text_font_size',
            [
                'label' => __('Pricing Text Font Size', 'ekw' ),
                'type' => Controls_Manager::SLIDER,
                'default' => [
                    'size' => 30,
                ],
                'range' => [
                    'px' => [
                        'max' => 80,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} #kaya-price-table, .price-body h2' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'pricing_text_font_weight',
            [
                'label' => __( 'Pricing Text Font Weight', 'ekw' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'normal' => __( 'Normal', 'ekw' ),
                    'bold' => __( 'Bold', 'ekw' ),
                ],
                'default' => 'bold',
                'selectors' => [
                    '{{WRAPPER}} #kaya-price-table, .price-body h2' => 'font-weight:{{VALUE}}!important;',
                ],
            ]
        );
        $this->add_control(
            'pricing_text_font_style',
            [
                'label' => __( 'Pricing Text Font Style', 'ekw' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'normal' => __( 'Normal', 'ekw' ),
                    'italic' => __( 'Italic', 'ekw' ),
                ],
                'default' => 'normal',
                'selectors' => [
                    '{{WRAPPER}} #kaya-price-table, .price-body h2' => 'font-style: {{VALUE}}!important;',
                ],
            ]
        );
        $this->end_controls_section();
        $this-> start_controls_section(
            'pricing_button',
            [
                'label' => __('Pricing Button', 'ekw'),
                'tab' => Controls_Manager::TAB_SETTINGS,
            ]
        );

        $this-> add_control(
            'pricing_button_note',
            [
                'label' => __('Note:If you want to give the custom link then empty the pmpro level ID to empty.','ekw'),
                'type' => Controls_Manager::HEADING,
                'condition' => [
                    'choose_pricing_button_text' => 'link',
                ],
            ]
        );

        $this->add_control(
            'choose_pricing_button_text',
            [
                'label' => __('Pricing Button Text','ekw'),
                'type' => Controls_Manager::SELECT,
                'default' => 'link',
                'options' => [
                    'pmpro_level' => __( 'Pmpro Level ID', 'ekw' ),
                    'link' => __( 'Link', 'ekw' ),
                ],
            ]
        );

        $this-> add_control(
            'level_id',
            [
                'label' => __('Pmpro Level ID', 'ekw'),
                'type' => Controls_Manager::TEXT,
                'description' => __('Enter pmpro level ID.EX:1', 'ekw'),  
                'condition' => [
                    'choose_pricing_button_text' => 'pmpro_level',
                ],
            ]
        );
        $this-> add_control(
            'pricing_button_link',
            [
                'label' => __('Button Link', 'ekw'),
                'type' => Controls_Manager::TEXT,
                'description' => __('Ex: http://www.google.com', 'ekw'),
                'condition' => [
                    'choose_pricing_button_text' => 'link',
                ],
            ]
        );
        $this->add_control(
            'pricing_button_text',
            [
                'label' => __('Pricing Button Text','ekw'),
                'type' => Controls_Manager::TEXT,
                'default' => __('Select','ekw'),
                'label_block' => true,
            ]
        );
        $this-> add_control(
            'pricing_button_font_size',
            [
                'label' => __('Pricing Button Font Size', 'ekw' ),
                'type' => Controls_Manager::SLIDER,
                'default' => [
                    'size' => 15,
                ],
                'range' => [
                    'px' => [

                       'max' => 80,
                   ],
                ],

                'selectors' => [
                    '{{WRAPPER}} #kaya-price-table, .button a' => 'font-size: {{SIZE}}{{UNIT}}!important;',
                ],
            ]
        );
        $this->add_control(
            'pricing_button_font_weight',
            [
                'label' => __( 'Pricing Button Font Weight', 'ekw' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'normal' => __( 'Normal', 'ekw' ),
                    'bold' => __( 'Bold', 'ekw' ),
                ],
                'default' => 'normal',
                'selectors' => [
                    '{{WRAPPER}} #kaya-price-table, .button a' => 'font-weight:{{VALUE}}!important;',
                ],
            ]
        );
        $this->add_control(
            'pricing_button_font_style',
            [
                'label' => __( 'Pricing Button Font Style', 'ekw' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'normal' => __( 'Normal', 'ekw' ),
                    'italic' => __( 'Italic', 'ekw' ),
                ],
                'default' => 'normal',
                'selectors' => [
                    '{{WRAPPER}} #kaya-price-table, .button a' => 'font-style: {{VALUE}}!important;',
                ],
            ]
        );
        $this-> end_controls_section();
        $this->start_controls_section(
            'section_pricing_borders',
            [
                'label' => __('Pricing Borders', 'ekw' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this-> add_control(
            'pricing_border_size',
            [
                'label' => __('Border Size(Px)','ekw'),
                'type' => Controls_Manager::NUMBER,
                'default' => 1,
                'selectors' => [
                    '{{WRAPPER}} .price-body' => 'border: {{VALUE}}px solid !important;',
                ],
            ]
        );
        $this-> add_control(
            'pricing_border_bottom_size',
            [
                'label' => __('Border Bottom Size(Px)', 'ekw'),
                'type' => Controls_Manager::NUMBER,
                'default' => 5,
                'selectors' => [
                    '{{WRAPPER}} .price-body' => 'border-bottom: {{VALUE}}px solid !important;',
                ],
            ]
        );
        $this-> add_control(
            'pricing_content_border_bottom_size',
            [
                'label' => __('Content Border Bottom Size(Px)', 'ekw'),
                'type' => Controls_Manager::NUMBER,
                'default' => 1,
                'selectors' => [
                    '{{WRAPPER}} #kaya-price-table, .price-body li' => 'border-bottom: {{VALUE}}px solid !important;',
                ],
            ]
        );
        $this-> end_controls_section();
        $this->start_controls_section(
            'section_pricing_colors',
            [
                'label' => __('Price Active Colors', 'ekw' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this-> add_control(
            'pricing_border_color',
            [
                'label' => __('Border Color', 'ekw'),
                'type' => Controls_Manager::COLOR,
                'default' => '#e4e4e4',
                'selectors' => [
                    '{{WRAPPER}} .price-body' => 'border-color: {{VALUE}}!important;',
                ],
            ]
        );
        $this-> add_control(
            'pricing_border_bottom_color',
            [
                'label' => __('Border Bottom Color', 'ekw'),
                'type' => Controls_Manager::COLOR,
                'default' => '#dcdcdc',
                'selectors' => [
                    '{{WRAPPER}} .price-body' => 'border-bottom-color: {{VALUE}}!important;',
                ],
            ]
        );
        $this-> add_control(
            'pricing_content_border_bottom_color',
            [
                'label' => __('Content Border Bottom Color', 'ekw'),
                'type' => Controls_Manager::COLOR,
                'default' => '#dcdcdc',
                'selectors' => [
                    '{{WRAPPER}} #kaya-price-table, .price-body li' => 'border-bottom-color: {{VALUE}}!important;',
                ],
            ]
        );
        $this-> add_control(
            'pricing_title_color',
            [
                'label' => __('Title Color', 'ekw'),
                'type' => Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .price-header h2' => 'color: {{VALUE}}!important;',
                ],
            ]
        );
        $this-> add_control(
            'pricing_desc_color',
            [
                'label' => __('Description Color', 'ekw'),
                'type' => Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .price-header p' => 'color: {{VALUE}}!important;',
                ],
            ]
        );
        $this-> add_control(
            'pricing_header_BG_color',
            [
                'label' => __('Header Background Color', 'ekw'),
                'type' => Controls_Manager::COLOR,
                'default' => '#fcc02e',
                'selectors' => [
                    '{{WRAPPER}} .price-header' => 'background-color: {{VALUE}}!important;',
                ],
            ]
        );

        $this-> add_control(
            'pricing_header_border_color',
            [
                'label' => __('Header Border Color', 'ekw'),
                'type' => Controls_Manager::COLOR,
                'default' => '#6e9e3a',
                'selectors' => [
                    '{{WRAPPER}} .price-header' => 'border-color: {{VALUE}}!important;',
                ],
            ]
        );
        $this-> add_control(
            'pricing_content_BG_color',
            [
                'label' => __('Content Background Color', 'ekw'),
                'type' => Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .price-body' => 'background-color: {{VALUE}}!important;',
                ],
            ]
        );
        $this-> add_control(
            'pricing_content_desc_color',
            [
                'label' => __('Content Text Color', 'ekw'),
                'type' => Controls_Manager::COLOR,
                'default' => '#808080',
                'selectors' => [
                    '{{WRAPPER}} .price-body ul' => 'color: {{VALUE}}!important;',
                ],
            ]
        );
        $this-> add_control(
            'pricing_price_color',
            [
                'label' => __('Price Color', 'ekw'),
                'type' => Controls_Manager::COLOR,
                'default' => '#000',
                'selectors' => [
                    '{{WRAPPER}} .price-body h2' => 'color: {{VALUE}}!important;',
                ],
            ]
        );
        $this->add_control(
            'price_text_color',
            [
                'label' => __('Price Text Color', 'ekw'),
                'type' => Controls_Manager::COLOR,
                'default' => '#afafaf',
                'selectors' => [
                    '{{WRAPPER}} .price-body strong' => 'color: {{VALUE}}!important;',
                ],
            ]
        );
        $this-> add_control(
            'pricing_button_BG_color',
            [
                'label' => __('Button Background Color', 'ekw'),
                'type' => Controls_Manager::COLOR,
                'default' => '#fcc02e',
                'selectors' => [
                    '{{WRAPPER}} .button a' => 'background-color: {{VALUE}}!important;',
                ],
            ]
        );
        $this-> add_control(
            'pricing_button_color',
            [
                'label' => __('Button Text Color', 'ekw'),
                'type' => Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .button a' => 'color: {{VALUE}}!important;',
                ],
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'section_pricing_hover_colors',
            [
                'label' => __('Pricing Hover Colors', 'ekw' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this-> add_control(
            'pricing_border_hover_color',
            [
                'label' => __('Border Hover Color', 'ekw'),
                'type' => Controls_Manager::COLOR,
                'default' => '#fcc02e',
                'selectors' => [
                    '{{WRAPPER}} .price-body:hover' => 'border-color: {{VALUE}}!important;',
                ],
            ]
        );
        $this-> add_control(
            'pricing_border_bottom_hover_color',
            [
                'label' => __('Border Bottom Hover Color', 'ekw'),
                'type' => Controls_Manager::COLOR,
                'default' => '#fcc02e',
                'selectors' => [
                    '{{WRAPPER}} .price-body:hover' => 'border-bottom-color: {{VALUE}}!important;',
                ],
            ]
        );
        $this-> add_control(
            'pricing_button_BG_hover_color',
            [
                'label' => __('Button Background Hover Color', 'ekw'),
                'type' => Controls_Manager::COLOR,
                'default' => '#ecb429',
                'selectors' =>  [
                    '{{WRAPPER}} .button a:hover' => 'background-color: {{VALUE}}!important;',
                ],
            ]
        );

        $this-> add_control(
            'pricing_button_text_hover_color',
            [
                'label' => __('Button Hover Color','ekw'),
                'type' => Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .button a:hover' => 'color: {{VALUE}}!important;',
                ],
            ]
        );
        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings();
        ?>
        <script>
        (function($) {
          "use strict";
            jQuery(document).ready(function($){
                $(function() {
                    $('pricing_title_text').change(function(){
                       var css = $(this).attr("name");
                       $(".price-header h2").css(css,$(this).val());
                    });
                });
            });
        });
        </script>
            <div id="kaya-price-table classic">
                <div class="price-header">
                    <!-- <figure class="price-image-post">
                       //<?php $image //= $this->get_settings( //'pricing_image_upload' ); 
                            //echo '<img src="' . $image['url'] . '">'; ?>
                    </figure>-->
                        <h2><?php echo $settings['pricing_title_text'] ?></h2>
                        <p><?php  echo $settings['pricing_desc_text'] ?></p>
                </div>
                    <div class="price-body">
                        <?php echo $settings['pricing_content_desc'] ?>
                        <h2><?php echo $settings['pricing_price']?></h2>
                        <?php
                        if(!empty($settings['level_id'])){
                            if( function_exists('elementor_kaya_pmpro_button') ){
                                echo '<div class="button">';
                                 
                                  

                                   if ( is_plugin_active( 'paid-memberships-pro/paid-memberships-pro.php' ) ) {
                                         echo elementor_kaya_pmpro_button($settings['level_id'], $settings['pricing_button_text']);
                                        } 

                                echo '</div>';
                            }
                        }
                        else{
                            echo '<div class="button">';
                                echo '<a href="'.$settings['pricing_button_link'].'">'.$settings['pricing_button_text'].'</a>';
                            echo '</div>';
                        }?>
                    </div>
            </div>
        <?php 
    }

    protected function content_template() {

    }
}