(function($) {
  "use strict";
  $(function() {
  
(function($){
  // select items, excluding those on shortlist page
  function shortlist_icons(){
    var action = $('a.item_button, .cpt_posts_add_remove a.action');
    shortlist.getItemTotal();
    shortlist.itemActions( action );
  }

  shortlist_icons();
});

// Model Short list Data added to ajax call back
var shortlist = (function($) {
  // define object literal container for parameters and methods
  var method = {};
   method.getItemTotal = function() {
    var counter = $('.shortlist-count'),
        clearAll = $('.shortlist-clear a');

    $.ajax({
      type: 'POST',
      url: kaya_ajax_url.ajaxurl,
       data : {
        action : 'kaya_pods_cpt_shortlist_items_count',
      },
      success: function(data) {
        counter.text('('+data+')');
      },
      error: function() {
        log('error with getItemTotal function');
      }
    });
  };
  /* Add & remove actions for individual items
   *
   * ajax method is wrapped inside itemActions() function
   *
   * method has 'button' parameter so jQuery object
   * can be passed in and run via $(button).on('click'...)
  -------------------------------------------------------- */

  method.itemActions = function(button) {
    $(button).on('click', function(e) {
        var target    = $(this),
          item      = target.closest('.item'),
          itemID    = item.attr('id'),
          itemAction= target.data('action');
        $.ajax({
          type: 'POST',
          url: kaya_ajax_url.ajaxurl,
          data : {
        action : 'kaya_pods_cpt_shortlist_items_remove_add',
        item_action : itemAction,
        item_id : itemID
      },
          success: function(data) {
            method.getItemTotal();
            log(itemAction + ' item ' + itemID);
            return false;
          },
          error: function(data) {
            log('error with itemActions function');
        }
      });

    if (itemAction === 'remove') {
      item.removeClass('item_selected');
    } else {
      item.addClass('item_selected');
    }
      e.preventDefault();
    });

  }; // end fn
  /* make methods accessible
  -------------------------- */
  return method;

});
});
}(jQuery)); // end of shortlist constructor
