<?php

function elementor_kaya_featured_img($image_sizes, $img_crop=''){
	$img_url = get_the_post_thumbnail_url();

	if($img_url){
		if( ($img_crop == 'custom_thumb_sizes') || ($img_crop == 'custom_image_sizes') || ($img_crop == 'custom')  ){
			echo '<img src="'.kaya_image_sizes($img_url, $image_sizes[0], $image_sizes[1], 't' ).'" />';
		}else{
			the_post_thumbnail($image_sizes);
		}
	}else{
		echo '<img src="'.ELEMENTOR_KAYA_PLUGIN_URL.'/images/default_image.jpg" height="400" width="400" alt="img" />';
	}
}
/**
 * Get POD CPT Fields names and information, based on cpt slug names
 * @param ( string ) $cpt_slug
 */
if( !function_exists('kaya_get_user_fields') ){
	function kaya_get_user_fields($cpt_slug='user'){
		if( !function_exists('pods_api') ){
			return false;
		}

	 	$pod_slug = pods_v( 'last', 'url' );
	    $pod_options_data = pods( $cpt_slug, $pod_slug );
	    if( !empty($pod_options_data) ){	    	
	      return $pod_options_data->api->fields;
	    }
	}
}

function kaya_get_current_user_style_role() {
	global $wp_roles;
	$current_user = wp_get_current_user();
	$roles = $current_user->roles;
	return $role = array_shift($roles);
}
// Get the user roles
function kaya_get_user_style_roles() {
    global $wp_roles;
    $user_role = array();
    $all_roles = $wp_roles->roles;
    $editable_roles = apply_filters('editable_roles', $all_roles);
  
   foreach ($editable_roles as $key => $role) {
		$user_role[$key] = $role['name'];  
   }
    return $user_role;
}
// Custom Avatar Image & Sizes
function get_avatar_image($user_id, $sizes){
	$user_profile_img = get_user_meta($user_id, 'avatar', true);	
	$img_url = @wp_get_attachment_image_src($user_profile_img['ID'], '');
	if( !empty($img_url) ){
		return '<img src="'.kaya_image_sizes($img_url[0], $sizes['width'],$sizes['height'], 't').'">';
	}else{
		return get_avatar($user_id, '350');
	}
}
/**
 * Get POD CPT Fields names and information, based on cpt slug names
 * @param ( string ) $cpt_slug
 */
if( !function_exists('kaya_get_pods_cpt_fields') ){
	function kaya_get_pods_cpt_fields($cpt_slug=''){
		
	 	$pod_slug = pods_v( 'last', 'url' );
	    $pod_options_data = pods( $cpt_slug, $pod_slug );
	    if( !empty($pod_options_data) ){	    	
	      return $pod_options_data->api->fields;
	    }
	}
}


function kaya_user_all_metakeys(){ 
	//add_action('')
    if( !function_exists('pods_api') ){
        return false;
    }
    	$meta_keys = array();
	   	$pods_options = pods_api()->load_pods( array( 'fields' => false ) );
		foreach ($pods_options as $key => $options) {  
		    if( ($options['type'] == 'user')){
			    foreach ($options['fields'] as $key => $fields_val) {
					 $meta_keys[$fields_val['name']] = $fields_val['label'];
			    	}
		    }
		} 
		return $meta_keys;

}
//Shortlist
function shortlist_info( $atts ) {
	if( function_exists('kaya_pods_cpt_shortlist_page_link') ){
    $shortlist_data = kaya_pods_cpt_shortlist_page_link();
	    if( !empty($shortlist_data) ){
	    echo '<div class="elementor-shortlist-align">';
	        echo $shortlist_data;
	    echo '</div>';
	    }  
	}
}
add_shortcode( 'post_shortlist_data', 'shortlist_info' );


function elementor_kaya_general_info($settings){
    if( !empty($settings['post_meta_keys']) ){
        echo '<div class="post-meta-general-info">';
            foreach ($settings['post_meta_keys'] as $key => $meta_key) {
              
                if( !function_exists('pods_api') ){
                    return false;
                }
                     
                $pods_options = pods_api()->load_pods( array( 'fields' => false ) );
                foreach ($pods_options as $key => $options) {     
                    if( ($options['type'] == 'post_type')){
                    	
                    	$replace_str = $options['name'].'s';
                    	$meta_key_replace =  str_replace($replace_str, '', $meta_key);
                    	$meta_data = get_post_meta(get_the_ID(),$meta_key_replace, true);
                        if( !empty($options['fields'][$meta_key_replace]['pod']) ){
                        if( in_array( $options['fields'][$meta_key_replace]['pod'], $settings['post_types']) ){
                            $meta_key_data = ( $meta_key_replace == 'age' ) ? $meta_key_replace.'_filter' : $meta_key_replace;
                            if( !empty($meta_data) ){
                                echo '<span  style="color:'.$settings['post_meta_color'].'"><b>'.$options['fields'][$meta_key_replace]['label'].':</b> '.get_post_meta(get_the_ID(),$meta_key_data, true).'</span>';
                            }
                        }

                    	}
                    }
                }                                    
            }
        echo '</div>';
    }
}
//Nav Menus
function elementor_kaya_nav_menu_selction() {
	$menus = wp_get_nav_menus();
	$items = array();
	$i     = 0;
	foreach ( $menus as $menu ) {
		if ( $i == 0 ) {
			$default = $menu->slug;
			$i ++;
		}
		$items[ $menu->slug ] = $menu->name;
	}

	return $items;
}
remove_filter( 'nav_menu_desc', 'strip_tags' );

function kaya_image_resize($url, $width, $height=0, $align='') {
  return mr_image_resize($url, $width, $height, true, $align, false);
}

function kaya_woo_all_taxonomies() {
    global $wpdb;
    $results = array();
    if( !empty($pods_options) ){
	    foreach ($pods_options as $key => $options) {  
		     if( $options['type'] == 'taxonomy' ){
	    		$terms_list = get_terms($options['name']);
	    		foreach ( $terms_list as $key => $terms) {
		    		 $results[$options['name'].':'.$terms->slug] = str_replace('_', ' ', ucwords($options['name'])).':'.$terms->name;
	    		}
	    	}
		}
	}
	$post_cats = get_categories();
	foreach ($post_cats as $key => $post_cat) {
		 $results['category:'.$post_cat->slug] = $post_cat->name.' : '.$post_cat->name;
	}
    return $results;
}

/**
	 * Get post types.
	 */
function woo_get_all_post_types() {
	$options = array();
	$exclude = array( 'attachment', 'elementor_library' ); // excluded post types
	$args = array(
		'public' => true,
	);
	foreach ( get_post_types( $args, 'objects' ) as $post_type ) {
		// Check if post type name exists.
		if ( ! isset( $post_type->name ) ) {
			continue;
		}
		// Check if post type label exists.
		if ( ! isset( $post_type->label ) ) {
			continue;
		}
		// Check if post type is excluded.
		if ( in_array( $post_type->name, $exclude ) === true ) {
			continue;
		}
		$options[ $post_type->name ] = $post_type->label;
	}
	return $options;
}

//Get post type categories.
function woo_get_all_post_type_categories( $post_type ) {
	$options = array();
	if ( $post_type == 'post' ) {
		$taxonomy = 'category';
	} elseif ( $post_type == 'product' ) {
		$taxonomy = 'product_cat';
	}
	if ( ! empty( $taxonomy ) ) {
		// Get categories for post type.
		$terms = get_terms(
			array(
				'taxonomy'   => $taxonomy,
				'hide_empty' => false,
			)
		);
		if ( ! empty( $terms ) ) {
			foreach ( $terms as $term ) {
				if ( isset( $term ) ) {
					if ( isset( $term->slug ) && isset( $term->name ) ) {
						$options[ $term->slug ] = $term->name;
					}
				}
			}
		}
	}
	return $options;
}

add_action('woocommerce_after_shop_loop_item', 'get_star_rating' );
function get_star_rating()
{
    global $woocommerce, $product;
    $average = $product->get_average_rating();
    echo '<div class="star-rating"><span style="width:'.( ( $average / 5 ) * 100 ) . '%"><strong itemprop="ratingValue" class="rating">'.$average.'</strong> '.__( 'out of 5', 'woocommerce' ).'</span></div>';
}

/**
	 * Display categories in meta section.
	 */
	 function kayaMetaGridCategories() {
		$settings           = $this->get_settings();
		$post_type_category = get_the_category();
		$maxCategories      = $settings['woo_meta_categories_max'] ? $settings['woo_meta_categories_max'] : '-1';
		$i                  = 0; // counter

		if ( $post_type_category ) { ?>
			<span class="obfx-grid-categories">
				<?php
				echo ( $settings['grid_meta_remove_icons'] == '' ) ? '<i class="fa fa-bookmark"></i>' : '';

				foreach ( $post_type_category as $category ) {
					if ( $i == $maxCategories ) {
						break;
					} ?>
					<span class="obfx-grid-categories-item">
						<a href="<?php echo get_category_link( $category->term_id ); ?>"
						   title="<?php echo $category->name; ?>">
							<?php echo $category->name; ?>
						</a>
					</span>
					<?php
					$i ++;
				} ?>
			</span>
			<?php
		}
	}

	/**
	 * Display tags in meta section.
	 */
	function kayaMetaGridTags() {
		$settings       = $this->get_settings();
		$post_type_tags = get_the_tags();
		$maxTags        = $settings['woo_meta_tags_max'] ? $settings['woo_meta_tags_max'] : '-1';
		$i              = 0; // counter

		if ( $post_type_tags ) { ?>
			<span class="obfx-grid-tags">
				<?php
				echo ( $settings['woo_meta_remove_icons'] == '' ) ? '<i class="fa fa-tags"></i>' : '';

				foreach ( $post_type_tags as $tag ) {
					if ( $i == $maxTags ) {
						break;
					} ?>
					<span class="obfx-grid-tags-item">
						<a href="<?php echo get_tag_link( $tag->term_id ); ?>" title="<?php echo $tag->name; ?>">
							<?php echo $tag->name; ?>
						</a>
					</span>
					<?php
					$i ++;
				} ?>
			</span>
			<?php
		}
	}

	/**
	 * Display Add to Cart button.
	 */
	function WooAddToCart() {

		if ( ! function_exists( 'wc_get_product' ) ) {
			return null;
		}

		$product = wc_get_product( get_the_ID() );

		echo apply_filters(
			'woocommerce_loop_add_to_cart_link',
			sprintf(
				'<a href="%s" title="%s" rel="nofollow">%s</a>',
				esc_url( $product->add_to_cart_url() ),
				esc_attr( $product->add_to_cart_text() ),
				esc_html( $product->add_to_cart_text() )
			), $product
		);
	}

	/**
	 * Display Add to Cart button.
	 */
	function WooAddToCartbutton() {

		if ( ! function_exists( 'wc_get_product' ) ) {
			return null;
		}

		$product = wc_get_product( get_the_ID() );

		echo apply_filters(
			'woocommerce_loop_add_to_cart_link',
			sprintf(
				'<a href="%s" title="%s" rel="nofollow"><i class="fa fa-shopping-cart"></i></a>',
				esc_url( $product->add_to_cart_url() ),
				esc_attr( $product->add_to_cart_text() ),
				esc_html( $product->add_to_cart_text() )
			), $product
		);
	}

//Pricing Table
function elementor_kaya_pmpro_shortcode_button($atts){
	extract(shortcode_atts(array(
		'level_id' => '',
		'pricing_button_text' => 'Select Level',
	) , $atts));
	return elementor_kaya_pmpro_button($level_id, $pricing_button_text);
}
add_shortcode('elementor_pmpro_kaya_button', 'elementor_kaya_pmpro_shortcode_button');


function elementor_kaya_pmpro_button(&$level_id, $pricing_button_text){
	global $wpdb, $pmpro_msg, $pmpro_msgt, $current_user, $pmpro_currency_symbol, $pmpro_all_levels, $pmpro_visible_levels, $membership_levels;
	$current_user->membership_level = (pmpro_getMembershipLevelForUser($current_user->ID));
	if (isset($current_user->membership_level->ID))
	{
		$current_level = ($current_user->membership_level->ID == $level_id);
	}
	else
	{
		$current_level = false;
	}
	if (empty($current_user->membership_level->ID))
	{ ?>
		<a class="pmpro_btn pmpro_btn-select" href="<?php echo pmpro_url("checkout", "?level=" . $level_id, "https") ?>"><?php echo trim(strip_tags($pricing_button_text)); ?></a>
	<?php
	}
	elseif (!$current_level)
	{ ?>
		<a class="pmpro_btn pmpro_btn-select" href="<?php echo pmpro_url("checkout", "?level=" . $level_id, "https") ?>"><?php echo trim(strip_tags($pricing_button_text)); ?></a>
	<?php
	}
	elseif ($current_level)
	{
		if (is_user_logged_in() && function_exists('pmpro_hasMembershipLevel') && pmpro_hasMembershipLevel())
		{
			global $current_user;
			$current_user->membership_level = pmpro_getMembershipLevelForUser($current_user->ID);
			$current_level = 'flase';
			if (pmpro_isLevelExpiringSoon($current_user->membership_level) && $current_user->membership_level->allow_signups)
			{ ?>
				<a class="pmpro_btn pmpro_btn-select" href="<?php echo pmpro_url("checkout", "?level=" . $level_id, "https") ?>"></a>
				<?php
			}
			else
			{ ?>
				<a class="pmpro_btn disabled" href="<?php echo pmpro_url("account") ?>"><?php _e('Your&nbsp;Level', 'pmpro'); ?></a> 
				<?php
			}
		}
	}
}
?>