<?php
add_action( 'admin_menu', 'kaya_pcv_export_option_settings' );
	/**
	 * Import and export settings
	 */
	function kaya_pcv_export_option_settings(){
        add_submenu_page('kaya-settings', __('Export','ekw'), __('Export','ekw'), 'edit_theme_options', 'ekw-export', 'kaya_pcv_export_option_page');
        add_submenu_page('kaya-settings', __('Import','ekw'), __('Import','ekw'), 'edit_theme_options', 'ekw-import', 'kaya_pcv_import_option_page');
    }
    
    function kaya_pcv_export_option_page() {
        if (!isset($_POST['ekw-export'])) { ?>
            <div class="wrap">
                <div id="icon-tools" class="icon32"><br /></div>
                <h2><?php esc_html_e('Export Pod CPT Views Settings','ekw'); ?> </h2>
                <p><?php _e('When you click <tt>Dowload Pod CPT Views Settings</tt> button, system will generate a JSON file for you to save on your computer.','ekw'); ?></p>
                <form method='post'>
                    <p class="submit">
                        <?php wp_nonce_field('ekw-options-export'); ?>
                        <input type='submit' name='ekw-export' value='<?php esc_html_e('Dowload Pod CPT Views Settings','ekw'); ?>' class="button"/>
                    </p>
                </form>
            </div>
            <?php
        }
        elseif (check_admin_referer('ekw-options-export')) {
            $blogname = str_replace(" ", "", get_option('blogname'));
            $date = date("m-d-Y");
            $json_name = $blogname."-".$date; // Namming the filename will be generated.
            $options = get_option('kaya_options'); // Get all options data, return array        
                foreach ($options as $key => $value) {
                $value = maybe_unserialize($value);
                $need_options[$key] = $value;
            }
            //$json_file = json_encode($need_options);
           // $need_options['front_page_name'] .= get_option('page_on_front');
            $json_file = json_encode($need_options); // Encode data into json data
            ob_clean();
            echo $json_file;
            header("Content-Type: text/json; charset=" . get_option( 'blog_charset'));
            header("Content-Disposition: attachment; filename=$json_name.json");
            exit();
        }
    }
     function kaya_pcv_import_option_page() {
        WP_Filesystem();
        global $wp_filesystem;
    ?>
    <div class="wrap">
        <div id="icon-tools" class="icon32"><br /></div>
        <h2><?php _e('Import Pods CPT Options', 'ekw'); ?></h2>
        <?php
            if (isset($_FILES['ekw-import']) && check_admin_referer('ekw-import')) {
                if ($_FILES['ekw-import']['error'] > 0) {
                    wp_die("Please Choose Upload json format file");
                }
                else {
                    $file_name = $_FILES['ekw-import']['name']; // Get the name of file
                    $file_path = explode('.', $file_name);
                    $file_ext = end($file_path);
                    $file_size = $_FILES['ekw-import']['size']; // Get size of file
                    /* Ensure uploaded file is JSON file type and the size not over 500000 bytes
                     * You can modify the size you want
                     */
                    if (($file_ext == "json") && ($file_size < 500000)) {
                        $encode_options = $wp_filesystem->get_contents($_FILES['ekw-import']['tmp_name']);
                        $pod_data = json_decode($encode_options, true); 
                        
                        $kaya_options = array();
                         foreach ($pod_data as $key => $opt_val) {
                            $kaya_options[$key] = $opt_val;
                            update_option( 'kaya_options', $kaya_options );
                         }
                         //$my_options['taxonomy_columns'] = '5';
                          //update_option( 'kaya_options', $my_options );


                        echo "<div class='updated'><p>".__('All options are restored successfully','ekw')."</p></div>";
                    }
                    else {
                        echo "<div class='error'><p>".__('Invalid file or file size too big.','ekw')."</p></div>";
                    }
                }
            }
        ?>
        <p><?php _e('Click Browse button and choose a json file that you backup before.','ekw'); ?> </p>
        <p><?php _e('Press Upload File and Import, WordPress do the rest for you.','ekw'); ?></p>
        <form method='post' enctype='multipart/form-data'>
            <p class="submit">
                <?php wp_nonce_field('ekw-import'); ?>
                <input type='file' name='ekw-import' class="primary-button"  />
                <input type='submit' name='submit' value='<?php _e('Upload File and Import', 'ekw') ?>' class="button"/>
            </p>
        </form>
    </div>
    <?php
}


?>
