<?php
/**
 * Plugin Name:Elementor - Kaya Widgets
 * Plugin URI: http://themeforest.net/user/kayapati
 * Description: Addon for Elementor to create Navmenu, select box , custom logo, pricing Table etc.
 * Version: 1.0.4
 * Author: Venisha IT Team
 * Author URI: http://themeforest.net/user/kayapati
 * Text Domain: ekw
 * Domain Path: /languages
 */

namespace ElementorKayaWidgets;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
/**
* Main Elementor Kaya Widget Classes
*/

if( !class_exists('Elementor_Kaya_Widgets') ){
	class Elementor_Kaya_Widgets
	{
		function __construct(){
			add_action( 'wp_enqueue_scripts', array( &$this, 'elementor_kaya_enqueue_styles' ) );
			add_action( 'admin_enqueue_scripts', array( &$this, 'elementor_kaya_admin_scripts' ) );
			add_action('plugins_loaded', array(&$this,'elementor_kaya_plugin_textdomain'));
			$this->elementor_kaya_include_files();
			$this->elementor_kaya_add_actions();
			add_action('elementor/editor/before_enqueue_scripts', array(&$this, 'elementor_kaya_front_end_styles'));
		}
		/**
		 * Load all files and functions
		 */
		function elementor_kaya_include_files(){
			define( 'ELEMENTOR_KAYA_PLUGIN_PATH',plugin_dir_path( __FILE__ ) );
			define( 'ELEMENTOR_KAYA_PLUGIN_URL',plugins_url( basename( plugin_dir_path( __FILE__ ) ), basename( __FILE__ ) ) );
			require_once plugin_dir_path( __FILE__ ) . 'includes/functions.php';
			require_once plugin_dir_path( __FILE__ ) . 'includes/mr-image-resize.php';
		}
		/**
		 * Loading Front End Css & Js Files
		 */
		public function elementor_kaya_enqueue_styles() {
			wp_enqueue_style('ekw-jquery-ui-css', plugins_url('css/jquery-ui-css.css', __FILE__));
			//wp_enqueue_script('masonry');
			wp_enqueue_style('ekw-styles', plugins_url('css/styles.css', __FILE__));
			wp_enqueue_style('owl.carousel.min', plugins_url('css/owl.carousel.min.css', __FILE__));
			wp_enqueue_script( 'owl.carousel.min', plugin_dir_url( __FILE__ ) . 'js/owl.carousel.min.js', array(),'', 'true' );
			//wp_enqueue_script('pod-cpt-scripts', plugin_dir_url( __FILE__ ) . 'js/scripts.js', array(),'', 'true' );
			wp_enqueue_style('ekw-responsive', plugins_url('css/responsive.css', __FILE__));
			wp_localize_script( 'jquery', 'kaya_ajax_url', array( 'ajaxurl' => admin_url( 'admin-ajax.php' )));
			wp_enqueue_script( 'jquery-ui-accordion' );
    		wp_enqueue_script( 'jquery-ui-autocomplete' );
			wp_enqueue_script('jquery-ui-slider');
		}
		
		/**
		 * Loading Admin Css & Js Files
		 */
		public function elementor_kaya_admin_scripts(){
			wp_enqueue_script('wp-color-picker');
			wp_enqueue_script( 'ekw-admin-scripts', plugin_dir_url( __FILE__ ) . 'js/admin-scripts.js', array(),'', 'true' );
			wp_enqueue_style('ekw-admin-styles', plugins_url('css/admin-styles.css', __FILE__));
		}
		
		/** 
		* Load language Translation Text Domain
		*/
	    public  function elementor_kaya_plugin_textdomain() {
	        $locale = apply_filters( 'plugin_locale', get_locale(), 'ekw' );
	        load_textdomain( 'ekw', trailingslashit( WP_LANG_DIR ) . '/' . $locale . '.mo' );
	        load_plugin_textdomain( 'ekw', FALSE, basename( dirname( __FILE__ ) ) . '/languages/' );
	    }

	    /**
		 * Add Actions
		 *
		 * @since 1.0.0
		 *
		 * @access private
		 */
		private function elementor_kaya_add_actions() {
			add_action( 'elementor/widgets/widgets_registered', [ $this, 'elementor_kaya_widgets_include' ] );
			add_action( 'elementor/frontend/after_register_scripts', function() {
				wp_enqueue_style('elementor-fe-styles', plugins_url('css/elementor-front-end-styles.css', __FILE__));
			} );
		}

		public function elementor_kaya_front_end_styles(){
			wp_enqueue_style('elementor-fe-styles', plugins_url('css/elementor-front-end-styles.css', __FILE__));
		}

		public function elementor_kaya_widgets_include($widgets_manager) {
			require_once ELEMENTOR_KAYA_PLUGIN_PATH . '/widgets/elementor-kaya-custom-logo.php';
			require_once ELEMENTOR_KAYA_PLUGIN_PATH . '/widgets/elementor-kaya-custom-selectbox.php';
			require_once ELEMENTOR_KAYA_PLUGIN_PATH . '/widgets/elementor-kaya-nav-menu.php';
			require_once ELEMENTOR_KAYA_PLUGIN_PATH . '/widgets/elementor-kaya-pricing-table.php';
			require_once ELEMENTOR_KAYA_PLUGIN_PATH . '/widgets/elementor-kaya-woo-product-slider.php';
			require_once ELEMENTOR_KAYA_PLUGIN_PATH . '/widgets/elementor-kaya-user-grid-slider-view.php';
			

			$widgets_manager->register_widget_type(new \ElementorKayaWidgets\Widgets\Elementor_Kaya_Custom_Logo());
			$widgets_manager->register_widget_type(new \ElementorKayaWidgets\Widgets\Elementor_Kaya_custom_select_box());
			$widgets_manager->register_widget_type(new \ElementorKayaWidgets\Widgets\Elementor_Kaya_Nav_Menu_Widget());
			$widgets_manager->register_widget_type(new \ElementorKayaWidgets\Widgets\Elementor_Kaya_Pricing_Table());
			$widgets_manager->register_widget_type(new \ElementorKayaWidgets\Widgets\Elementor_Kaya_Woo_Product_Slider());
			$widgets_manager->register_widget_type(new \ElementorKayaWidgets\Widgets\Kaya_User_Grid_Slider_Widget());
		}
	}
}

new Elementor_Kaya_Widgets();  ?>