<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/assuredworkloads/v1beta1/assuredworkloads_v1beta1.proto

namespace Google\Cloud\AssuredWorkloads\V1beta1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * An Workload object for managing highly regulated workloads of cloud
 * customers.
 *
 * Generated from protobuf message <code>google.cloud.assuredworkloads.v1beta1.Workload</code>
 */
class Workload extends \Google\Protobuf\Internal\Message
{
    /**
     * Optional. The resource name of the workload.
     * Format:
     * organizations/{organization}/locations/{location}/workloads/{workload}
     * Read-only.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $name = '';
    /**
     * Required. The user-assigned display name of the Workload.
     * When present it must be between 4 to 30 characters.
     * Allowed characters are: lowercase and uppercase letters, numbers,
     * hyphen, and spaces.
     * Example: My Workload
     *
     * Generated from protobuf field <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $display_name = '';
    /**
     * Output only. The resources associated with this workload.
     * These resources will be created when creating the workload.
     * If any of the projects already exist, the workload creation will fail.
     * Always read only.
     *
     * Generated from protobuf field <code>repeated .google.cloud.assuredworkloads.v1beta1.Workload.ResourceInfo resources = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $resources;
    /**
     * Required. Immutable. Compliance Regime associated with this workload.
     *
     * Generated from protobuf field <code>.google.cloud.assuredworkloads.v1beta1.Workload.ComplianceRegime compliance_regime = 4 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];</code>
     */
    private $compliance_regime = 0;
    /**
     * Output only. Immutable. The Workload creation timestamp.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IMMUTABLE];</code>
     */
    private $create_time = null;
    /**
     * Required. Input only. The billing account used for the resources which are
     * direct children of workload. This billing account is initially associated
     * with the resources created as part of Workload creation.
     * After the initial creation of these resources, the customer can change
     * the assigned billing account.
     * The resource name has the form
     * `billingAccounts/{billing_account_id}`. For example,
     * `billingAccounts/012345-567890-ABCDEF`.
     *
     * Generated from protobuf field <code>string billing_account = 6 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = INPUT_ONLY];</code>
     */
    private $billing_account = '';
    /**
     * Optional. ETag of the workload, it is calculated on the basis
     * of the Workload contents. It will be used in Update & Delete operations.
     *
     * Generated from protobuf field <code>string etag = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $etag = '';
    /**
     * Optional. Labels applied to the workload.
     *
     * Generated from protobuf field <code>map<string, string> labels = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $labels;
    /**
     * Input only. The parent resource for the resources managed by this Assured Workload. May
     * be either an organization or a folder. Must be the same or a child of the
     * Workload parent. If not specified all resources are created under the
     * Workload parent.
     * Formats:
     * folders/{folder_id}
     * organizations/{organization_id}
     *
     * Generated from protobuf field <code>string provisioned_resources_parent = 13 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     */
    private $provisioned_resources_parent = '';
    /**
     * Input only. Settings used to create a CMEK crypto key. When set a project with a KMS
     * CMEK key is provisioned. This field is mandatory for a subset of Compliance
     * Regimes.
     *
     * Generated from protobuf field <code>.google.cloud.assuredworkloads.v1beta1.Workload.KMSSettings kms_settings = 14 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     */
    private $kms_settings = null;
    protected $compliance_regime_settings;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Optional. The resource name of the workload.
     *           Format:
     *           organizations/{organization}/locations/{location}/workloads/{workload}
     *           Read-only.
     *     @type string $display_name
     *           Required. The user-assigned display name of the Workload.
     *           When present it must be between 4 to 30 characters.
     *           Allowed characters are: lowercase and uppercase letters, numbers,
     *           hyphen, and spaces.
     *           Example: My Workload
     *     @type \Google\Cloud\AssuredWorkloads\V1beta1\Workload\ResourceInfo[]|\Google\Protobuf\Internal\RepeatedField $resources
     *           Output only. The resources associated with this workload.
     *           These resources will be created when creating the workload.
     *           If any of the projects already exist, the workload creation will fail.
     *           Always read only.
     *     @type int $compliance_regime
     *           Required. Immutable. Compliance Regime associated with this workload.
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Output only. Immutable. The Workload creation timestamp.
     *     @type string $billing_account
     *           Required. Input only. The billing account used for the resources which are
     *           direct children of workload. This billing account is initially associated
     *           with the resources created as part of Workload creation.
     *           After the initial creation of these resources, the customer can change
     *           the assigned billing account.
     *           The resource name has the form
     *           `billingAccounts/{billing_account_id}`. For example,
     *           `billingAccounts/012345-567890-ABCDEF`.
     *     @type \Google\Cloud\AssuredWorkloads\V1beta1\Workload\IL4Settings $il4_settings
     *           Required. Input only. Immutable. Settings specific to resources needed for IL4.
     *     @type \Google\Cloud\AssuredWorkloads\V1beta1\Workload\CJISSettings $cjis_settings
     *           Required. Input only. Immutable. Settings specific to resources needed for CJIS.
     *     @type \Google\Cloud\AssuredWorkloads\V1beta1\Workload\FedrampHighSettings $fedramp_high_settings
     *           Required. Input only. Immutable. Settings specific to resources needed for FedRAMP High.
     *     @type \Google\Cloud\AssuredWorkloads\V1beta1\Workload\FedrampModerateSettings $fedramp_moderate_settings
     *           Required. Input only. Immutable. Settings specific to resources needed for FedRAMP Moderate.
     *     @type string $etag
     *           Optional. ETag of the workload, it is calculated on the basis
     *           of the Workload contents. It will be used in Update & Delete operations.
     *     @type array|\Google\Protobuf\Internal\MapField $labels
     *           Optional. Labels applied to the workload.
     *     @type string $provisioned_resources_parent
     *           Input only. The parent resource for the resources managed by this Assured Workload. May
     *           be either an organization or a folder. Must be the same or a child of the
     *           Workload parent. If not specified all resources are created under the
     *           Workload parent.
     *           Formats:
     *           folders/{folder_id}
     *           organizations/{organization_id}
     *     @type \Google\Cloud\AssuredWorkloads\V1beta1\Workload\KMSSettings $kms_settings
     *           Input only. Settings used to create a CMEK crypto key. When set a project with a KMS
     *           CMEK key is provisioned. This field is mandatory for a subset of Compliance
     *           Regimes.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Assuredworkloads\V1Beta1\AssuredworkloadsV1Beta1::initOnce();
        parent::__construct($data);
    }

    /**
     * Optional. The resource name of the workload.
     * Format:
     * organizations/{organization}/locations/{location}/workloads/{workload}
     * Read-only.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Optional. The resource name of the workload.
     * Format:
     * organizations/{organization}/locations/{location}/workloads/{workload}
     * Read-only.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Required. The user-assigned display name of the Workload.
     * When present it must be between 4 to 30 characters.
     * Allowed characters are: lowercase and uppercase letters, numbers,
     * hyphen, and spaces.
     * Example: My Workload
     *
     * Generated from protobuf field <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getDisplayName()
    {
        return $this->display_name;
    }

    /**
     * Required. The user-assigned display name of the Workload.
     * When present it must be between 4 to 30 characters.
     * Allowed characters are: lowercase and uppercase letters, numbers,
     * hyphen, and spaces.
     * Example: My Workload
     *
     * Generated from protobuf field <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setDisplayName($var)
    {
        GPBUtil::checkString($var, True);
        $this->display_name = $var;

        return $this;
    }

    /**
     * Output only. The resources associated with this workload.
     * These resources will be created when creating the workload.
     * If any of the projects already exist, the workload creation will fail.
     * Always read only.
     *
     * Generated from protobuf field <code>repeated .google.cloud.assuredworkloads.v1beta1.Workload.ResourceInfo resources = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getResources()
    {
        return $this->resources;
    }

    /**
     * Output only. The resources associated with this workload.
     * These resources will be created when creating the workload.
     * If any of the projects already exist, the workload creation will fail.
     * Always read only.
     *
     * Generated from protobuf field <code>repeated .google.cloud.assuredworkloads.v1beta1.Workload.ResourceInfo resources = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Cloud\AssuredWorkloads\V1beta1\Workload\ResourceInfo[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setResources($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\AssuredWorkloads\V1beta1\Workload\ResourceInfo::class);
        $this->resources = $arr;

        return $this;
    }

    /**
     * Required. Immutable. Compliance Regime associated with this workload.
     *
     * Generated from protobuf field <code>.google.cloud.assuredworkloads.v1beta1.Workload.ComplianceRegime compliance_regime = 4 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];</code>
     * @return int
     */
    public function getComplianceRegime()
    {
        return $this->compliance_regime;
    }

    /**
     * Required. Immutable. Compliance Regime associated with this workload.
     *
     * Generated from protobuf field <code>.google.cloud.assuredworkloads.v1beta1.Workload.ComplianceRegime compliance_regime = 4 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];</code>
     * @param int $var
     * @return $this
     */
    public function setComplianceRegime($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\AssuredWorkloads\V1beta1\Workload\ComplianceRegime::class);
        $this->compliance_regime = $var;

        return $this;
    }

    /**
     * Output only. Immutable. The Workload creation timestamp.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IMMUTABLE];</code>
     * @return \Google\Protobuf\Timestamp
     */
    public function getCreateTime()
    {
        return isset($this->create_time) ? $this->create_time : null;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Output only. Immutable. The Workload creation timestamp.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IMMUTABLE];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Required. Input only. The billing account used for the resources which are
     * direct children of workload. This billing account is initially associated
     * with the resources created as part of Workload creation.
     * After the initial creation of these resources, the customer can change
     * the assigned billing account.
     * The resource name has the form
     * `billingAccounts/{billing_account_id}`. For example,
     * `billingAccounts/012345-567890-ABCDEF`.
     *
     * Generated from protobuf field <code>string billing_account = 6 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = INPUT_ONLY];</code>
     * @return string
     */
    public function getBillingAccount()
    {
        return $this->billing_account;
    }

    /**
     * Required. Input only. The billing account used for the resources which are
     * direct children of workload. This billing account is initially associated
     * with the resources created as part of Workload creation.
     * After the initial creation of these resources, the customer can change
     * the assigned billing account.
     * The resource name has the form
     * `billingAccounts/{billing_account_id}`. For example,
     * `billingAccounts/012345-567890-ABCDEF`.
     *
     * Generated from protobuf field <code>string billing_account = 6 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = INPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setBillingAccount($var)
    {
        GPBUtil::checkString($var, True);
        $this->billing_account = $var;

        return $this;
    }

    /**
     * Required. Input only. Immutable. Settings specific to resources needed for IL4.
     *
     * Generated from protobuf field <code>.google.cloud.assuredworkloads.v1beta1.Workload.IL4Settings il4_settings = 7 [deprecated = true, (.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = INPUT_ONLY, (.google.api.field_behavior) = IMMUTABLE];</code>
     * @return \Google\Cloud\AssuredWorkloads\V1beta1\Workload\IL4Settings
     */
    public function getIl4Settings()
    {
        return $this->readOneof(7);
    }

    public function hasIl4Settings()
    {
        return $this->hasOneof(7);
    }

    /**
     * Required. Input only. Immutable. Settings specific to resources needed for IL4.
     *
     * Generated from protobuf field <code>.google.cloud.assuredworkloads.v1beta1.Workload.IL4Settings il4_settings = 7 [deprecated = true, (.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = INPUT_ONLY, (.google.api.field_behavior) = IMMUTABLE];</code>
     * @param \Google\Cloud\AssuredWorkloads\V1beta1\Workload\IL4Settings $var
     * @return $this
     */
    public function setIl4Settings($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\AssuredWorkloads\V1beta1\Workload\IL4Settings::class);
        $this->writeOneof(7, $var);

        return $this;
    }

    /**
     * Required. Input only. Immutable. Settings specific to resources needed for CJIS.
     *
     * Generated from protobuf field <code>.google.cloud.assuredworkloads.v1beta1.Workload.CJISSettings cjis_settings = 8 [deprecated = true, (.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = INPUT_ONLY, (.google.api.field_behavior) = IMMUTABLE];</code>
     * @return \Google\Cloud\AssuredWorkloads\V1beta1\Workload\CJISSettings
     */
    public function getCjisSettings()
    {
        return $this->readOneof(8);
    }

    public function hasCjisSettings()
    {
        return $this->hasOneof(8);
    }

    /**
     * Required. Input only. Immutable. Settings specific to resources needed for CJIS.
     *
     * Generated from protobuf field <code>.google.cloud.assuredworkloads.v1beta1.Workload.CJISSettings cjis_settings = 8 [deprecated = true, (.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = INPUT_ONLY, (.google.api.field_behavior) = IMMUTABLE];</code>
     * @param \Google\Cloud\AssuredWorkloads\V1beta1\Workload\CJISSettings $var
     * @return $this
     */
    public function setCjisSettings($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\AssuredWorkloads\V1beta1\Workload\CJISSettings::class);
        $this->writeOneof(8, $var);

        return $this;
    }

    /**
     * Required. Input only. Immutable. Settings specific to resources needed for FedRAMP High.
     *
     * Generated from protobuf field <code>.google.cloud.assuredworkloads.v1beta1.Workload.FedrampHighSettings fedramp_high_settings = 11 [deprecated = true, (.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = INPUT_ONLY, (.google.api.field_behavior) = IMMUTABLE];</code>
     * @return \Google\Cloud\AssuredWorkloads\V1beta1\Workload\FedrampHighSettings
     */
    public function getFedrampHighSettings()
    {
        return $this->readOneof(11);
    }

    public function hasFedrampHighSettings()
    {
        return $this->hasOneof(11);
    }

    /**
     * Required. Input only. Immutable. Settings specific to resources needed for FedRAMP High.
     *
     * Generated from protobuf field <code>.google.cloud.assuredworkloads.v1beta1.Workload.FedrampHighSettings fedramp_high_settings = 11 [deprecated = true, (.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = INPUT_ONLY, (.google.api.field_behavior) = IMMUTABLE];</code>
     * @param \Google\Cloud\AssuredWorkloads\V1beta1\Workload\FedrampHighSettings $var
     * @return $this
     */
    public function setFedrampHighSettings($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\AssuredWorkloads\V1beta1\Workload\FedrampHighSettings::class);
        $this->writeOneof(11, $var);

        return $this;
    }

    /**
     * Required. Input only. Immutable. Settings specific to resources needed for FedRAMP Moderate.
     *
     * Generated from protobuf field <code>.google.cloud.assuredworkloads.v1beta1.Workload.FedrampModerateSettings fedramp_moderate_settings = 12 [deprecated = true, (.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = INPUT_ONLY, (.google.api.field_behavior) = IMMUTABLE];</code>
     * @return \Google\Cloud\AssuredWorkloads\V1beta1\Workload\FedrampModerateSettings
     */
    public function getFedrampModerateSettings()
    {
        return $this->readOneof(12);
    }

    public function hasFedrampModerateSettings()
    {
        return $this->hasOneof(12);
    }

    /**
     * Required. Input only. Immutable. Settings specific to resources needed for FedRAMP Moderate.
     *
     * Generated from protobuf field <code>.google.cloud.assuredworkloads.v1beta1.Workload.FedrampModerateSettings fedramp_moderate_settings = 12 [deprecated = true, (.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = INPUT_ONLY, (.google.api.field_behavior) = IMMUTABLE];</code>
     * @param \Google\Cloud\AssuredWorkloads\V1beta1\Workload\FedrampModerateSettings $var
     * @return $this
     */
    public function setFedrampModerateSettings($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\AssuredWorkloads\V1beta1\Workload\FedrampModerateSettings::class);
        $this->writeOneof(12, $var);

        return $this;
    }

    /**
     * Optional. ETag of the workload, it is calculated on the basis
     * of the Workload contents. It will be used in Update & Delete operations.
     *
     * Generated from protobuf field <code>string etag = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getEtag()
    {
        return $this->etag;
    }

    /**
     * Optional. ETag of the workload, it is calculated on the basis
     * of the Workload contents. It will be used in Update & Delete operations.
     *
     * Generated from protobuf field <code>string etag = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setEtag($var)
    {
        GPBUtil::checkString($var, True);
        $this->etag = $var;

        return $this;
    }

    /**
     * Optional. Labels applied to the workload.
     *
     * Generated from protobuf field <code>map<string, string> labels = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getLabels()
    {
        return $this->labels;
    }

    /**
     * Optional. Labels applied to the workload.
     *
     * Generated from protobuf field <code>map<string, string> labels = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setLabels($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->labels = $arr;

        return $this;
    }

    /**
     * Input only. The parent resource for the resources managed by this Assured Workload. May
     * be either an organization or a folder. Must be the same or a child of the
     * Workload parent. If not specified all resources are created under the
     * Workload parent.
     * Formats:
     * folders/{folder_id}
     * organizations/{organization_id}
     *
     * Generated from protobuf field <code>string provisioned_resources_parent = 13 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     * @return string
     */
    public function getProvisionedResourcesParent()
    {
        return $this->provisioned_resources_parent;
    }

    /**
     * Input only. The parent resource for the resources managed by this Assured Workload. May
     * be either an organization or a folder. Must be the same or a child of the
     * Workload parent. If not specified all resources are created under the
     * Workload parent.
     * Formats:
     * folders/{folder_id}
     * organizations/{organization_id}
     *
     * Generated from protobuf field <code>string provisioned_resources_parent = 13 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setProvisionedResourcesParent($var)
    {
        GPBUtil::checkString($var, True);
        $this->provisioned_resources_parent = $var;

        return $this;
    }

    /**
     * Input only. Settings used to create a CMEK crypto key. When set a project with a KMS
     * CMEK key is provisioned. This field is mandatory for a subset of Compliance
     * Regimes.
     *
     * Generated from protobuf field <code>.google.cloud.assuredworkloads.v1beta1.Workload.KMSSettings kms_settings = 14 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     * @return \Google\Cloud\AssuredWorkloads\V1beta1\Workload\KMSSettings
     */
    public function getKmsSettings()
    {
        return isset($this->kms_settings) ? $this->kms_settings : null;
    }

    public function hasKmsSettings()
    {
        return isset($this->kms_settings);
    }

    public function clearKmsSettings()
    {
        unset($this->kms_settings);
    }

    /**
     * Input only. Settings used to create a CMEK crypto key. When set a project with a KMS
     * CMEK key is provisioned. This field is mandatory for a subset of Compliance
     * Regimes.
     *
     * Generated from protobuf field <code>.google.cloud.assuredworkloads.v1beta1.Workload.KMSSettings kms_settings = 14 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     * @param \Google\Cloud\AssuredWorkloads\V1beta1\Workload\KMSSettings $var
     * @return $this
     */
    public function setKmsSettings($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\AssuredWorkloads\V1beta1\Workload\KMSSettings::class);
        $this->kms_settings = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getComplianceRegimeSettings()
    {
        return $this->whichOneof("compliance_regime_settings");
    }

}

