<?php

// load GCS library
require_once 'vendor/autoload.php';

use Google\Cloud\Storage\StorageClient;

// Please use your own private key (JSON file content) which was downloaded in step 3 and copy it here
// your private key JSON structure should be similar like dummy value below.
// WARNING: this is only for QUICK TESTING to verify whether private key is valid (working) or not.  
// NOTE: to create private key JSON file: https://console.cloud.google.com/apis/credentials  
$privateKeyFileContent = '{
  "type": "service_account",
  "project_id": "i-state-303208",
  "private_key_id": "f04dc504c9169336ff210edb6e3e682c1aaf172e",
  "private_key": "-----BEGIN PRIVATE KEY-----\nMIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQC1s8v/er5TOsqe\nZFtZ/8eTsTjbY7pTOiWEPm1T98g2CDl0/NBYLWsGfMXgzj8UuWjcywM255NZruIl\n4GiYhL/xwn5ifLt9B0kthUh8vEXS+ue+iryRdTdPgohLC9xQaqN/w0KRdorhqD2H\nfOqsQ8YXImW5+7+Pz3c38LB9YNQewDBFN9FEiOWGL7bNdVVR4tOeV02wCTssZlgP\njpCOcH6ecKnewahQ1t5/fjyfiU84giKNY0vtxhfMcEcIvatwpToWGFlPmlEsXH6T\nLxen4XH8LY3I1RbU2I7k5d+pjcuFfrnH74dZZ2maI42uB/FO2Yk555rPRmfAczBu\nulCvlzNnAgMBAAECggEADRQxYuUFk3LFPZF2YeFfZD96xY/wIX2ApdGN3QrA2+LL\nqqK9UcYzJfcP50FGmR9KGlp36MPSf2oZ19Act0hsPeKvZjdu525W03KnPRNFk2Is\nEYhlpQgNldOM1poL9F3jVuxJ0QlPWzQuTvUBj1TG4B4XDxln4y9zzWWtzoM3Ft9v\njYK+JtSiR3xGetLUSb0wcg5CSzFYHOaQAnBpDI4sdmFjbFsOcor5XvRyWQbDTCIN\n2uDklMGvMl3aH70agILLb0BvBUwRewpjAoTaT+yXIjpLFtmKukbt9Exhp5DEOJ3u\nF/EaLBpbLSh8OJOOIwDuSpsm7gJKmuS9HG4aKzpdAQKBgQDX7xQwiarBepW/aF8O\nFTlCTu2ETvEsqoni20msFNn/iWac/BEcX4amRYQwxauiyjAe5a7CA1isXVmy2vOK\nzXsygLtzIwmG8ya3zTfDig7U5bJHgVawNSjuulKpEl3N1lIXcqkH+3a64E/2S3wZ\nHPQpqkxTZSx+FbMkLE5noHgy0QKBgQDXarVyMPLGVhAp8vsewidZx+LSRdW+JCh0\ntzaFat6CTuWhDQdeMsq5pCvB5PLbTlZkfalHw5flWmjSiW+PLxro8Aif0j2lOZQ8\ncw1aOYXSQx7ykn51wZqhJhtbIkV+HZ6YLIJwd+NDX8KVvEgLEWLFP4BHWfi9ZHRc\nqEVY/vTgtwKBgB3xiVsxu/wYg6uHTacmSkpnp4gxakBHZdePkSfLvG8zHoembLkC\nhimIekxJHQP2BbZDI3jD/gfo6gdjVWJqHCtkrpnIwgl0rmnOi20SN/xN3esMhHjq\n5kI0lEHdyiRBFCEsRURWGqDPekctMIhK+5DLjMoDvae+Wpkpi7XTCtgBAoGBAJY/\nGRryRQJM2K1Jihkj9epK3ksm5jPeaFEv0Fkx9swQV10DB1aOOpNMjDCKjVCkzOD+\nPGmPZIxViLL/pM3LXwuFD57ZNqHdDSU0YeXCJTJIGne58XYUeNNZDs97kdiqtAkT\nUk87b0l4qvFhByahE7Db347kk/cU74wI2YV/HjD1AoGBAIcTQFVxys8sDKhtlvQF\ngLDDyFPuT+k8vrxZtgbMwc1HvO3HsFU9sICYeEoca7/I7IG6wdM852CuqfmxhIjq\nxY5Fsi47ekTwtUYQai1BLWvMVRYOQzMwcHi26TdlhQ53t/j849sa44zTkD0i9jRj\nYaVEXY8i89jHSBtZHHwQV/Bg\n-----END PRIVATE KEY-----\n",
  "client_email": "gcp-storage-upload@i-state-303208.iam.gserviceaccount.com",
  "client_id": "108236646123551108748",
  "auth_uri": "https://accounts.google.com/o/oauth2/auth",
  "token_uri": "https://oauth2.googleapis.com/token",
  "auth_provider_x509_cert_url": "https://www.googleapis.com/oauth2/v1/certs",
  "client_x509_cert_url": "https://www.googleapis.com/robot/v1/metadata/x509/gcp-storage-upload%40i-state-303208.iam.gserviceaccount.com"
}';

/*
 * NOTE: if the server is a shared hosting by third party company then private key should not be stored as a file,
 * may be better to encrypt the private key value then store the 'encrypted private key' value as string in database,
 * so every time before use the private key we can get a user-input (from UI) to get password to decrypt it.
 */

function uploadFile($bucketName, $fileContent, $cloudPath) {
    $privateKeyFileContent = $GLOBALS['privateKeyFileContent'];
    // connect to Google Cloud Storage using private key as authentication
    try {
        $storage = new StorageClient([
            'keyFile' => json_decode($privateKeyFileContent, true)
        ]);
    } catch (Exception $e) {
        // maybe invalid private key ?
        print $e;
        return false;
    }

    // set which bucket to work in
    $bucket = $storage->bucket($bucketName);

    // upload/replace file 
    $storageObject = $bucket->upload(
            $fileContent,
            ['name' => $cloudPath]
            // if $cloudPath is existed then will be overwrite without confirmation
            // NOTE: 
            // a. do not put prefix '/', '/' is a separate folder name  !!
            // b. private key MUST have 'storage.objects.delete' permission if want to replace file !
    );

    // is it succeed ?
    return $storageObject != null;
}

function getFileInfo($bucketName, $cloudPath) {
    $privateKeyFileContent = $GLOBALS['privateKeyFileContent'];
    // connect to Google Cloud Storage using private key as authentication
    try {
        $storage = new StorageClient([
            'keyFile' => json_decode($privateKeyFileContent, true)
        ]);
    } catch (Exception $e) {
        // maybe invalid private key ?
        print $e;
        return false;
    }

    // set which bucket to work in
    $bucket = $storage->bucket($bucketName);
    $object = $bucket->object($cloudPath);
    return $object->info();
}
//this (listFiles) method not used in this example but you may use according to your need 
function listFiles($bucket, $directory = null) {

    if ($directory == null) {
        // list all files
        $objects = $bucket->objects();
    } else {
        // list all files within a directory (sub-directory)
        $options = array('prefix' => $directory);
        $objects = $bucket->objects($options);
    }

    foreach ($objects as $object) {
        print $object->name() . PHP_EOL;
        // NOTE: if $object->name() ends with '/' then it is a 'folder'
    }
}

function deleteFile($bucketName, $objectName, $options = [])
{
    $privateKeyFileContent = $GLOBALS['privateKeyFileContent'];
    // connect to Google Cloud Storage using private key as authentication
    try {
        $storage = new StorageClient([
            'keyFile' => json_decode($privateKeyFileContent, true)
        ]);
    } catch (Exception $e) {
        // maybe invalid private key ?
        print $e;
        return false;
    }

    $bucket = $storage->bucket($bucketName);
    $object = $bucket->object($objectName);
    $object->delete();
    return true;
}