<?php
/*
Plugin Name: CF7 custom
*/

/**
 * Generated by the WordPress Option Page generator
 * at http://jeremyhixon.com/wp-tools/option-page/
 */

class CotactFormCustomOptions {
	private $cotact_form_7_custom_options_options;

	public function __construct() {
		add_action( 'admin_menu', array( $this, 'cotact_form_7_custom_options_add_plugin_page' ) );
		add_action( 'admin_init', array( $this, 'cotact_form_7_custom_options_page_init' ) );
	}

	public function cotact_form_7_custom_options_add_plugin_page() {
		add_options_page(
			'CF7 - UM Email Options', // page_title
			'CF7 - UM Email Options', // menu_title
			'manage_options', // capability
			'cotact-form-7-custom-options', // menu_slug
			array( $this, 'cotact_form_7_custom_options_create_admin_page' ) // function
		);
	}

	public function cotact_form_7_custom_options_create_admin_page() {
		$this->cotact_form_7_custom_options_options = get_option( 'cotact_form_7_custom_options_option_name' ); ?>

		<div class="wrap">
			<h2>Contact form 7 Custom Options</h2>
			<p></p>
			<?php settings_errors(); ?>

			<form method="post" action="options.php">
				<?php
					settings_fields( 'cotact_form_7_custom_options_option_group' );
					do_settings_sections( 'cotact-form-7-custom-options-admin' );
					submit_button();
				?>
			</form>
		</div>
	<?php }

	public function cotact_form_7_custom_options_page_init() {
		register_setting(
			'cotact_form_7_custom_options_option_group', // option_group
			'cotact_form_7_custom_options_option_name', // option_name
			array( $this, 'cotact_form_7_custom_options_sanitize' ) // sanitize_callback
		);

		add_settings_section(
			'cotact_form_7_custom_options_setting_section', // id
			'Settings', // title
			array( $this, 'cotact_form_7_custom_options_section_info' ), // callback
			'cotact-form-7-custom-options-admin' // page
		);

		add_settings_field(
			'select_contact_form_0', // id
			'Select Contact Form', // title
			array( $this, 'select_contact_form_0_callback' ), // callback
			'cotact-form-7-custom-options-admin', // page
			'cotact_form_7_custom_options_setting_section' // section
		);

		add_settings_field(
			'email_to_admin_1', // id
			'Email To Admin', // title
			array( $this, 'email_to_admin_1_callback' ), // callback
			'cotact-form-7-custom-options-admin', // page
			'cotact_form_7_custom_options_setting_section' // section
		);
	}

	public function cotact_form_7_custom_options_sanitize($input) {
		$sanitary_values = array();
		if ( isset( $input['select_contact_form_0'] ) ) {
			$sanitary_values['select_contact_form_0'] = $input['select_contact_form_0'];
		}

		if ( isset( $input['email_to_admin_1'] ) ) {
			$sanitary_values['email_to_admin_1'] = $input['email_to_admin_1'];
		}

		return $sanitary_values;
	}

	public function cotact_form_7_custom_options_section_info() {
		
	}

	public function select_contact_form_0_callback() {
		 $args = array('post_type' => 'wpcf7_contact_form', 'posts_per_page' => -1);
		 $cf7Forms = get_posts( $args );
		 $form_titles = wp_list_pluck( $cf7Forms , 'post_title' );

		?> <select name="cotact_form_7_custom_options_option_name[select_contact_form_0]" id="select_contact_form_0">
			<?php foreach($form_titles as $item): ?>
			<?php $selected = (isset( $this->cotact_form_7_custom_options_options['select_contact_form_0'] ) && $this->cotact_form_7_custom_options_options['select_contact_form_0'] ===  $item) ? 'selected' : '' ; ?>
				<option value="<?php echo $item; ?>" <?php echo $selected; ?>><?php echo $item; ?></option>
			<?php endforeach; ?>
			
		</select> <?php
	}

	public function email_to_admin_1_callback() {
		?> <select name="cotact_form_7_custom_options_option_name[email_to_admin_1]" id="email_to_admin_1">
			<?php $selected = (isset( $this->cotact_form_7_custom_options_options['email_to_admin_1'] ) && $this->cotact_form_7_custom_options_options['email_to_admin_1'] === 'yes') ? 'selected' : '' ; ?>
			<option value="yes" <?php echo $selected; ?>>Yes</option>
			<?php $selected = (isset( $this->cotact_form_7_custom_options_options['email_to_admin_1'] ) && $this->cotact_form_7_custom_options_options['email_to_admin_1'] === 'no') ? 'selected' : '' ; ?>
			<option value="no" <?php echo $selected; ?>>No</option>
		</select> <?php
	}

}
if ( is_admin() )
	$cotact_form_7_custom_options = new CotactFormCustomOptions();

/* 
 * Retrieve this value with:
 * $cotact_form_7_custom_options_options = get_option( 'cotact_form_7_custom_options_option_name' ); // Array of All Options
 * $select_contact_form_0 = $cotact_form_7_custom_options_options['select_contact_form_0']; // Select Contact Form
 * $email_to_admin_1 = $cotact_form_7_custom_options_options['email_to_admin_1']; // Email To Admin
 */



// hook into wpcf7_before_send_mail
add_action( 'wpcf7_before_send_mail', function($contact_form){
	$cotact_form_7_custom_options_options = get_option( 'cotact_form_7_custom_options_option_name' );
	$select_contact_form_0 = $cotact_form_7_custom_options_options['select_contact_form_0'];
	$email_to_admin_1 = $cotact_form_7_custom_options_options['email_to_admin_1'];	
	if($contact_form->title === $select_contact_form_0){
		// get current user email
		$arr = explode('/', $_SERVER['REDIRECT_URL']);
		$count = count($arr);
		$user = get_user_by('slug', $arr[$count-2]);
		$current_user_email = $user->user_email;

		// create new instance of WPCF7_Submission class
		$submission = WPCF7_Submission::get_instance();
		 
		$toEmail = array();

		$mailProp = $contact_form->get_properties('mail');
		if($email_to_admin_1 == 'yes'){
			$toEmail[] = $mailProp['mail']['recipient'];
		}
		// email address you want to change
		if($current_user_email){
			$toEmail[] = $current_user_email;
		}

		$toEmail = implode(',', $toEmail);

		// die($toEmail);
		
		// set the email address to recipient
		$mailProp['mail']['recipient'] = $toEmail;
		 
		// update the form properties
		$contact_form->set_properties(array('mail' => $mailProp['mail']));
	}
	
});